/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.IncrementalPullConfig;
import software.amazon.awssdk.services.appflow.model.SourceConnectorProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceFlowConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceFlowConfig> {
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(SourceFlowConfig.getter(SourceFlowConfig::connectorTypeAsString)).setter(SourceFlowConfig.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(SourceFlowConfig.getter(SourceFlowConfig::connectorProfileName)).setter(SourceFlowConfig.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final SdkField<SourceConnectorProperties> SOURCE_CONNECTOR_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConnectorProperties").getter(SourceFlowConfig.getter(SourceFlowConfig::sourceConnectorProperties)).setter(SourceFlowConfig.setter(Builder::sourceConnectorProperties)).constructor(SourceConnectorProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectorProperties").build()}).build();
    private static final SdkField<IncrementalPullConfig> INCREMENTAL_PULL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("incrementalPullConfig").getter(SourceFlowConfig.getter(SourceFlowConfig::incrementalPullConfig)).setter(SourceFlowConfig.setter(Builder::incrementalPullConfig)).constructor(IncrementalPullConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalPullConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPE_FIELD, CONNECTOR_PROFILE_NAME_FIELD, SOURCE_CONNECTOR_PROPERTIES_FIELD, INCREMENTAL_PULL_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectorType;
    private final String connectorProfileName;
    private final SourceConnectorProperties sourceConnectorProperties;
    private final IncrementalPullConfig incrementalPullConfig;

    private SourceFlowConfig(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.connectorProfileName = builder.connectorProfileName;
        this.sourceConnectorProperties = builder.sourceConnectorProperties;
        this.incrementalPullConfig = builder.incrementalPullConfig;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    public final SourceConnectorProperties sourceConnectorProperties() {
        return this.sourceConnectorProperties;
    }

    public final IncrementalPullConfig incrementalPullConfig() {
        return this.incrementalPullConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnectorProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementalPullConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFlowConfig)) {
            return false;
        }
        SourceFlowConfig other = (SourceFlowConfig)obj;
        return Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.sourceConnectorProperties(), other.sourceConnectorProperties()) && Objects.equals(this.incrementalPullConfig(), other.incrementalPullConfig());
    }

    public final String toString() {
        return ToString.builder((String)"SourceFlowConfig").add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorProfileName", (Object)this.connectorProfileName()).add("SourceConnectorProperties", (Object)this.sourceConnectorProperties()).add("IncrementalPullConfig", (Object)this.incrementalPullConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "sourceConnectorProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceConnectorProperties()));
            }
            case "incrementalPullConfig": {
                return Optional.ofNullable(clazz.cast(this.incrementalPullConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceFlowConfig, T> g) {
        return obj -> g.apply((SourceFlowConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorType;
        private String connectorProfileName;
        private SourceConnectorProperties sourceConnectorProperties;
        private IncrementalPullConfig incrementalPullConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFlowConfig model) {
            this.connectorType(model.connectorType);
            this.connectorProfileName(model.connectorProfileName);
            this.sourceConnectorProperties(model.sourceConnectorProperties);
            this.incrementalPullConfig(model.incrementalPullConfig);
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        @Transient
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        @Transient
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final SourceConnectorProperties.Builder getSourceConnectorProperties() {
            return this.sourceConnectorProperties != null ? this.sourceConnectorProperties.toBuilder() : null;
        }

        public final void setSourceConnectorProperties(SourceConnectorProperties.BuilderImpl sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties != null ? sourceConnectorProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceConnectorProperties(SourceConnectorProperties sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties;
            return this;
        }

        public final IncrementalPullConfig.Builder getIncrementalPullConfig() {
            return this.incrementalPullConfig != null ? this.incrementalPullConfig.toBuilder() : null;
        }

        public final void setIncrementalPullConfig(IncrementalPullConfig.BuilderImpl incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig != null ? incrementalPullConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder incrementalPullConfig(IncrementalPullConfig incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig;
            return this;
        }

        public SourceFlowConfig build() {
            return new SourceFlowConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceFlowConfig> {
        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorProfileName(String var1);

        public Builder sourceConnectorProperties(SourceConnectorProperties var1);

        default public Builder sourceConnectorProperties(Consumer<SourceConnectorProperties.Builder> sourceConnectorProperties) {
            return this.sourceConnectorProperties((SourceConnectorProperties)((SourceConnectorProperties.Builder)SourceConnectorProperties.builder().applyMutation(sourceConnectorProperties)).build());
        }

        public Builder incrementalPullConfig(IncrementalPullConfig var1);

        default public Builder incrementalPullConfig(Consumer<IncrementalPullConfig.Builder> incrementalPullConfig) {
            return this.incrementalPullConfig((IncrementalPullConfig)((IncrementalPullConfig.Builder)IncrementalPullConfig.builder().applyMutation(incrementalPullConfig)).build());
        }
    }
}

