/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorProfileResponse extends AppflowResponse implements
        ToCopyableBuilder<UpdateConnectorProfileResponse.Builder, UpdateConnectorProfileResponse> {
    private static final SdkField<String> CONNECTOR_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileArn").getter(getter(UpdateConnectorProfileResponse::connectorProfileArn))
            .setter(setter(Builder::connectorProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_ARN_FIELD));

    private final String connectorProfileArn;

    private UpdateConnectorProfileResponse(BuilderImpl builder) {
        super(builder);
        this.connectorProfileArn = builder.connectorProfileArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector profile.
     */
    public final String connectorProfileArn() {
        return connectorProfileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorProfileResponse)) {
            return false;
        }
        UpdateConnectorProfileResponse other = (UpdateConnectorProfileResponse) obj;
        return Objects.equals(connectorProfileArn(), other.connectorProfileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorProfileResponse").add("ConnectorProfileArn", connectorProfileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileArn":
            return Optional.ofNullable(clazz.cast(connectorProfileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorProfileResponse, T> g) {
        return obj -> g.apply((UpdateConnectorProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectorProfileResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector profile.
         * </p>
         * 
         * @param connectorProfileArn
         *        The Amazon Resource Name (ARN) of the connector profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileArn(String connectorProfileArn);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private String connectorProfileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorProfileResponse model) {
            super(model);
            connectorProfileArn(model.connectorProfileArn);
        }

        public final String getConnectorProfileArn() {
            return connectorProfileArn;
        }

        @Override
        public final Builder connectorProfileArn(String connectorProfileArn) {
            this.connectorProfileArn = connectorProfileArn;
            return this;
        }

        public final void setConnectorProfileArn(String connectorProfileArn) {
            this.connectorProfileArn = connectorProfileArn;
        }

        @Override
        public UpdateConnectorProfileResponse build() {
            return new UpdateConnectorProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
