/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration details that control the trigger for a flow. Currently, these settings only apply to the
 * <code>Scheduled</code> trigger type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<TriggerProperties.Builder, TriggerProperties> {
    private static final SdkField<ScheduledTriggerProperties> SCHEDULED_FIELD = SdkField
            .<ScheduledTriggerProperties> builder(MarshallingType.SDK_POJO).memberName("Scheduled")
            .getter(getter(TriggerProperties::scheduled)).setter(setter(Builder::scheduled))
            .constructor(ScheduledTriggerProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheduled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_FIELD));

    private static final long serialVersionUID = 1L;

    private final ScheduledTriggerProperties scheduled;

    private TriggerProperties(BuilderImpl builder) {
        this.scheduled = builder.scheduled;
    }

    /**
     * <p>
     * Specifies the configuration details of a schedule-triggered flow as defined by the user.
     * </p>
     * 
     * @return Specifies the configuration details of a schedule-triggered flow as defined by the user.
     */
    public final ScheduledTriggerProperties scheduled() {
        return scheduled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerProperties)) {
            return false;
        }
        TriggerProperties other = (TriggerProperties) obj;
        return Objects.equals(scheduled(), other.scheduled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TriggerProperties").add("Scheduled", scheduled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scheduled":
            return Optional.ofNullable(clazz.cast(scheduled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerProperties, T> g) {
        return obj -> g.apply((TriggerProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerProperties> {
        /**
         * <p>
         * Specifies the configuration details of a schedule-triggered flow as defined by the user.
         * </p>
         * 
         * @param scheduled
         *        Specifies the configuration details of a schedule-triggered flow as defined by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduled(ScheduledTriggerProperties scheduled);

        /**
         * <p>
         * Specifies the configuration details of a schedule-triggered flow as defined by the user.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledTriggerProperties.Builder} avoiding the
         * need to create one manually via {@link ScheduledTriggerProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledTriggerProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #scheduled(ScheduledTriggerProperties)}.
         * 
         * @param scheduled
         *        a consumer that will call methods on {@link ScheduledTriggerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduled(ScheduledTriggerProperties)
         */
        default Builder scheduled(Consumer<ScheduledTriggerProperties.Builder> scheduled) {
            return scheduled(ScheduledTriggerProperties.builder().applyMutation(scheduled).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScheduledTriggerProperties scheduled;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerProperties model) {
            scheduled(model.scheduled);
        }

        public final ScheduledTriggerProperties.Builder getScheduled() {
            return scheduled != null ? scheduled.toBuilder() : null;
        }

        @Override
        public final Builder scheduled(ScheduledTriggerProperties scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public final void setScheduled(ScheduledTriggerProperties.BuilderImpl scheduled) {
            this.scheduled = scheduled != null ? scheduled.build() : null;
        }

        @Override
        public TriggerProperties build() {
            return new TriggerProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
