/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the information that is required to query a particular connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceConnectorProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceConnectorProperties.Builder, SourceConnectorProperties> {
    private static final SdkField<AmplitudeSourceProperties> AMPLITUDE_FIELD = SdkField
            .<AmplitudeSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Amplitude")
            .getter(getter(SourceConnectorProperties::amplitude)).setter(setter(Builder::amplitude))
            .constructor(AmplitudeSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amplitude").build()).build();

    private static final SdkField<DatadogSourceProperties> DATADOG_FIELD = SdkField
            .<DatadogSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Datadog")
            .getter(getter(SourceConnectorProperties::datadog)).setter(setter(Builder::datadog))
            .constructor(DatadogSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datadog").build()).build();

    private static final SdkField<DynatraceSourceProperties> DYNATRACE_FIELD = SdkField
            .<DynatraceSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Dynatrace")
            .getter(getter(SourceConnectorProperties::dynatrace)).setter(setter(Builder::dynatrace))
            .constructor(DynatraceSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynatrace").build()).build();

    private static final SdkField<GoogleAnalyticsSourceProperties> GOOGLE_ANALYTICS_FIELD = SdkField
            .<GoogleAnalyticsSourceProperties> builder(MarshallingType.SDK_POJO).memberName("GoogleAnalytics")
            .getter(getter(SourceConnectorProperties::googleAnalytics)).setter(setter(Builder::googleAnalytics))
            .constructor(GoogleAnalyticsSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleAnalytics").build()).build();

    private static final SdkField<InforNexusSourceProperties> INFOR_NEXUS_FIELD = SdkField
            .<InforNexusSourceProperties> builder(MarshallingType.SDK_POJO).memberName("InforNexus")
            .getter(getter(SourceConnectorProperties::inforNexus)).setter(setter(Builder::inforNexus))
            .constructor(InforNexusSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InforNexus").build()).build();

    private static final SdkField<MarketoSourceProperties> MARKETO_FIELD = SdkField
            .<MarketoSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Marketo")
            .getter(getter(SourceConnectorProperties::marketo)).setter(setter(Builder::marketo))
            .constructor(MarketoSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()).build();

    private static final SdkField<S3SourceProperties> S3_FIELD = SdkField.<S3SourceProperties> builder(MarshallingType.SDK_POJO)
            .memberName("S3").getter(getter(SourceConnectorProperties::s3)).setter(setter(Builder::s3))
            .constructor(S3SourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final SdkField<SalesforceSourceProperties> SALESFORCE_FIELD = SdkField
            .<SalesforceSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Salesforce")
            .getter(getter(SourceConnectorProperties::salesforce)).setter(setter(Builder::salesforce))
            .constructor(SalesforceSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<ServiceNowSourceProperties> SERVICE_NOW_FIELD = SdkField
            .<ServiceNowSourceProperties> builder(MarshallingType.SDK_POJO).memberName("ServiceNow")
            .getter(getter(SourceConnectorProperties::serviceNow)).setter(setter(Builder::serviceNow))
            .constructor(ServiceNowSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final SdkField<SingularSourceProperties> SINGULAR_FIELD = SdkField
            .<SingularSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Singular")
            .getter(getter(SourceConnectorProperties::singular)).setter(setter(Builder::singular))
            .constructor(SingularSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Singular").build()).build();

    private static final SdkField<SlackSourceProperties> SLACK_FIELD = SdkField
            .<SlackSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Slack")
            .getter(getter(SourceConnectorProperties::slack)).setter(setter(Builder::slack))
            .constructor(SlackSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slack").build()).build();

    private static final SdkField<TrendmicroSourceProperties> TRENDMICRO_FIELD = SdkField
            .<TrendmicroSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Trendmicro")
            .getter(getter(SourceConnectorProperties::trendmicro)).setter(setter(Builder::trendmicro))
            .constructor(TrendmicroSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trendmicro").build()).build();

    private static final SdkField<VeevaSourceProperties> VEEVA_FIELD = SdkField
            .<VeevaSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Veeva")
            .getter(getter(SourceConnectorProperties::veeva)).setter(setter(Builder::veeva))
            .constructor(VeevaSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Veeva").build()).build();

    private static final SdkField<ZendeskSourceProperties> ZENDESK_FIELD = SdkField
            .<ZendeskSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Zendesk")
            .getter(getter(SourceConnectorProperties::zendesk)).setter(setter(Builder::zendesk))
            .constructor(ZendeskSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLITUDE_FIELD,
            DATADOG_FIELD, DYNATRACE_FIELD, GOOGLE_ANALYTICS_FIELD, INFOR_NEXUS_FIELD, MARKETO_FIELD, S3_FIELD, SALESFORCE_FIELD,
            SERVICE_NOW_FIELD, SINGULAR_FIELD, SLACK_FIELD, TRENDMICRO_FIELD, VEEVA_FIELD, ZENDESK_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmplitudeSourceProperties amplitude;

    private final DatadogSourceProperties datadog;

    private final DynatraceSourceProperties dynatrace;

    private final GoogleAnalyticsSourceProperties googleAnalytics;

    private final InforNexusSourceProperties inforNexus;

    private final MarketoSourceProperties marketo;

    private final S3SourceProperties s3;

    private final SalesforceSourceProperties salesforce;

    private final ServiceNowSourceProperties serviceNow;

    private final SingularSourceProperties singular;

    private final SlackSourceProperties slack;

    private final TrendmicroSourceProperties trendmicro;

    private final VeevaSourceProperties veeva;

    private final ZendeskSourceProperties zendesk;

    private SourceConnectorProperties(BuilderImpl builder) {
        this.amplitude = builder.amplitude;
        this.datadog = builder.datadog;
        this.dynatrace = builder.dynatrace;
        this.googleAnalytics = builder.googleAnalytics;
        this.inforNexus = builder.inforNexus;
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.singular = builder.singular;
        this.slack = builder.slack;
        this.trendmicro = builder.trendmicro;
        this.veeva = builder.veeva;
        this.zendesk = builder.zendesk;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Amplitude.
     * </p>
     * 
     * @return Specifies the information that is required for querying Amplitude.
     */
    public final AmplitudeSourceProperties amplitude() {
        return amplitude;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Datadog.
     * </p>
     * 
     * @return Specifies the information that is required for querying Datadog.
     */
    public final DatadogSourceProperties datadog() {
        return datadog;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Dynatrace.
     * </p>
     * 
     * @return Specifies the information that is required for querying Dynatrace.
     */
    public final DynatraceSourceProperties dynatrace() {
        return dynatrace;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Google Analytics.
     * </p>
     * 
     * @return Specifies the information that is required for querying Google Analytics.
     */
    public final GoogleAnalyticsSourceProperties googleAnalytics() {
        return googleAnalytics;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Infor Nexus.
     * </p>
     * 
     * @return Specifies the information that is required for querying Infor Nexus.
     */
    public final InforNexusSourceProperties inforNexus() {
        return inforNexus;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Marketo.
     * </p>
     * 
     * @return Specifies the information that is required for querying Marketo.
     */
    public final MarketoSourceProperties marketo() {
        return marketo;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Amazon S3.
     * </p>
     * 
     * @return Specifies the information that is required for querying Amazon S3.
     */
    public final S3SourceProperties s3() {
        return s3;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Salesforce.
     * </p>
     * 
     * @return Specifies the information that is required for querying Salesforce.
     */
    public final SalesforceSourceProperties salesforce() {
        return salesforce;
    }

    /**
     * <p>
     * Specifies the information that is required for querying ServiceNow.
     * </p>
     * 
     * @return Specifies the information that is required for querying ServiceNow.
     */
    public final ServiceNowSourceProperties serviceNow() {
        return serviceNow;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Singular.
     * </p>
     * 
     * @return Specifies the information that is required for querying Singular.
     */
    public final SingularSourceProperties singular() {
        return singular;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Slack.
     * </p>
     * 
     * @return Specifies the information that is required for querying Slack.
     */
    public final SlackSourceProperties slack() {
        return slack;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Trend Micro.
     * </p>
     * 
     * @return Specifies the information that is required for querying Trend Micro.
     */
    public final TrendmicroSourceProperties trendmicro() {
        return trendmicro;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Veeva.
     * </p>
     * 
     * @return Specifies the information that is required for querying Veeva.
     */
    public final VeevaSourceProperties veeva() {
        return veeva;
    }

    /**
     * <p>
     * Specifies the information that is required for querying Zendesk.
     * </p>
     * 
     * @return Specifies the information that is required for querying Zendesk.
     */
    public final ZendeskSourceProperties zendesk() {
        return zendesk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amplitude());
        hashCode = 31 * hashCode + Objects.hashCode(datadog());
        hashCode = 31 * hashCode + Objects.hashCode(dynatrace());
        hashCode = 31 * hashCode + Objects.hashCode(googleAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(inforNexus());
        hashCode = 31 * hashCode + Objects.hashCode(marketo());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNow());
        hashCode = 31 * hashCode + Objects.hashCode(singular());
        hashCode = 31 * hashCode + Objects.hashCode(slack());
        hashCode = 31 * hashCode + Objects.hashCode(trendmicro());
        hashCode = 31 * hashCode + Objects.hashCode(veeva());
        hashCode = 31 * hashCode + Objects.hashCode(zendesk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectorProperties)) {
            return false;
        }
        SourceConnectorProperties other = (SourceConnectorProperties) obj;
        return Objects.equals(amplitude(), other.amplitude()) && Objects.equals(datadog(), other.datadog())
                && Objects.equals(dynatrace(), other.dynatrace()) && Objects.equals(googleAnalytics(), other.googleAnalytics())
                && Objects.equals(inforNexus(), other.inforNexus()) && Objects.equals(marketo(), other.marketo())
                && Objects.equals(s3(), other.s3()) && Objects.equals(salesforce(), other.salesforce())
                && Objects.equals(serviceNow(), other.serviceNow()) && Objects.equals(singular(), other.singular())
                && Objects.equals(slack(), other.slack()) && Objects.equals(trendmicro(), other.trendmicro())
                && Objects.equals(veeva(), other.veeva()) && Objects.equals(zendesk(), other.zendesk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceConnectorProperties").add("Amplitude", amplitude()).add("Datadog", datadog())
                .add("Dynatrace", dynatrace()).add("GoogleAnalytics", googleAnalytics()).add("InforNexus", inforNexus())
                .add("Marketo", marketo()).add("S3", s3()).add("Salesforce", salesforce()).add("ServiceNow", serviceNow())
                .add("Singular", singular()).add("Slack", slack()).add("Trendmicro", trendmicro()).add("Veeva", veeva())
                .add("Zendesk", zendesk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amplitude":
            return Optional.ofNullable(clazz.cast(amplitude()));
        case "Datadog":
            return Optional.ofNullable(clazz.cast(datadog()));
        case "Dynatrace":
            return Optional.ofNullable(clazz.cast(dynatrace()));
        case "GoogleAnalytics":
            return Optional.ofNullable(clazz.cast(googleAnalytics()));
        case "InforNexus":
            return Optional.ofNullable(clazz.cast(inforNexus()));
        case "Marketo":
            return Optional.ofNullable(clazz.cast(marketo()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforce()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNow()));
        case "Singular":
            return Optional.ofNullable(clazz.cast(singular()));
        case "Slack":
            return Optional.ofNullable(clazz.cast(slack()));
        case "Trendmicro":
            return Optional.ofNullable(clazz.cast(trendmicro()));
        case "Veeva":
            return Optional.ofNullable(clazz.cast(veeva()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendesk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectorProperties, T> g) {
        return obj -> g.apply((SourceConnectorProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceConnectorProperties> {
        /**
         * <p>
         * Specifies the information that is required for querying Amplitude.
         * </p>
         * 
         * @param amplitude
         *        Specifies the information that is required for querying Amplitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amplitude(AmplitudeSourceProperties amplitude);

        /**
         * <p>
         * Specifies the information that is required for querying Amplitude.
         * </p>
         * This is a convenience that creates an instance of the {@link AmplitudeSourceProperties.Builder} avoiding the
         * need to create one manually via {@link AmplitudeSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link AmplitudeSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #amplitude(AmplitudeSourceProperties)}.
         * 
         * @param amplitude
         *        a consumer that will call methods on {@link AmplitudeSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amplitude(AmplitudeSourceProperties)
         */
        default Builder amplitude(Consumer<AmplitudeSourceProperties.Builder> amplitude) {
            return amplitude(AmplitudeSourceProperties.builder().applyMutation(amplitude).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Datadog.
         * </p>
         * 
         * @param datadog
         *        Specifies the information that is required for querying Datadog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datadog(DatadogSourceProperties datadog);

        /**
         * <p>
         * Specifies the information that is required for querying Datadog.
         * </p>
         * This is a convenience that creates an instance of the {@link DatadogSourceProperties.Builder} avoiding the
         * need to create one manually via {@link DatadogSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatadogSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #datadog(DatadogSourceProperties)}.
         * 
         * @param datadog
         *        a consumer that will call methods on {@link DatadogSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datadog(DatadogSourceProperties)
         */
        default Builder datadog(Consumer<DatadogSourceProperties.Builder> datadog) {
            return datadog(DatadogSourceProperties.builder().applyMutation(datadog).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Dynatrace.
         * </p>
         * 
         * @param dynatrace
         *        Specifies the information that is required for querying Dynatrace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynatrace(DynatraceSourceProperties dynatrace);

        /**
         * <p>
         * Specifies the information that is required for querying Dynatrace.
         * </p>
         * This is a convenience that creates an instance of the {@link DynatraceSourceProperties.Builder} avoiding the
         * need to create one manually via {@link DynatraceSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DynatraceSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #dynatrace(DynatraceSourceProperties)}.
         * 
         * @param dynatrace
         *        a consumer that will call methods on {@link DynatraceSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynatrace(DynatraceSourceProperties)
         */
        default Builder dynatrace(Consumer<DynatraceSourceProperties.Builder> dynatrace) {
            return dynatrace(DynatraceSourceProperties.builder().applyMutation(dynatrace).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Google Analytics.
         * </p>
         * 
         * @param googleAnalytics
         *        Specifies the information that is required for querying Google Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder googleAnalytics(GoogleAnalyticsSourceProperties googleAnalytics);

        /**
         * <p>
         * Specifies the information that is required for querying Google Analytics.
         * </p>
         * This is a convenience that creates an instance of the {@link GoogleAnalyticsSourceProperties.Builder}
         * avoiding the need to create one manually via {@link GoogleAnalyticsSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link GoogleAnalyticsSourceProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #googleAnalytics(GoogleAnalyticsSourceProperties)}.
         * 
         * @param googleAnalytics
         *        a consumer that will call methods on {@link GoogleAnalyticsSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #googleAnalytics(GoogleAnalyticsSourceProperties)
         */
        default Builder googleAnalytics(Consumer<GoogleAnalyticsSourceProperties.Builder> googleAnalytics) {
            return googleAnalytics(GoogleAnalyticsSourceProperties.builder().applyMutation(googleAnalytics).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Infor Nexus.
         * </p>
         * 
         * @param inforNexus
         *        Specifies the information that is required for querying Infor Nexus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inforNexus(InforNexusSourceProperties inforNexus);

        /**
         * <p>
         * Specifies the information that is required for querying Infor Nexus.
         * </p>
         * This is a convenience that creates an instance of the {@link InforNexusSourceProperties.Builder} avoiding the
         * need to create one manually via {@link InforNexusSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link InforNexusSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #inforNexus(InforNexusSourceProperties)}.
         * 
         * @param inforNexus
         *        a consumer that will call methods on {@link InforNexusSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inforNexus(InforNexusSourceProperties)
         */
        default Builder inforNexus(Consumer<InforNexusSourceProperties.Builder> inforNexus) {
            return inforNexus(InforNexusSourceProperties.builder().applyMutation(inforNexus).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Marketo.
         * </p>
         * 
         * @param marketo
         *        Specifies the information that is required for querying Marketo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketo(MarketoSourceProperties marketo);

        /**
         * <p>
         * Specifies the information that is required for querying Marketo.
         * </p>
         * This is a convenience that creates an instance of the {@link MarketoSourceProperties.Builder} avoiding the
         * need to create one manually via {@link MarketoSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link MarketoSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #marketo(MarketoSourceProperties)}.
         * 
         * @param marketo
         *        a consumer that will call methods on {@link MarketoSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketo(MarketoSourceProperties)
         */
        default Builder marketo(Consumer<MarketoSourceProperties.Builder> marketo) {
            return marketo(MarketoSourceProperties.builder().applyMutation(marketo).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Amazon S3.
         * </p>
         * 
         * @param s3
         *        Specifies the information that is required for querying Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3SourceProperties s3);

        /**
         * <p>
         * Specifies the information that is required for querying Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3SourceProperties.Builder} avoiding the need to
         * create one manually via {@link S3SourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3SourceProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #s3(S3SourceProperties)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3SourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3SourceProperties)
         */
        default Builder s3(Consumer<S3SourceProperties.Builder> s3) {
            return s3(S3SourceProperties.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Salesforce.
         * </p>
         * 
         * @param salesforce
         *        Specifies the information that is required for querying Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceSourceProperties salesforce);

        /**
         * <p>
         * Specifies the information that is required for querying Salesforce.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceSourceProperties.Builder} avoiding the
         * need to create one manually via {@link SalesforceSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #salesforce(SalesforceSourceProperties)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceSourceProperties)
         */
        default Builder salesforce(Consumer<SalesforceSourceProperties.Builder> salesforce) {
            return salesforce(SalesforceSourceProperties.builder().applyMutation(salesforce).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying ServiceNow.
         * </p>
         * 
         * @param serviceNow
         *        Specifies the information that is required for querying ServiceNow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNow(ServiceNowSourceProperties serviceNow);

        /**
         * <p>
         * Specifies the information that is required for querying ServiceNow.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceNowSourceProperties.Builder} avoiding the
         * need to create one manually via {@link ServiceNowSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceNowSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceNow(ServiceNowSourceProperties)}.
         * 
         * @param serviceNow
         *        a consumer that will call methods on {@link ServiceNowSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNow(ServiceNowSourceProperties)
         */
        default Builder serviceNow(Consumer<ServiceNowSourceProperties.Builder> serviceNow) {
            return serviceNow(ServiceNowSourceProperties.builder().applyMutation(serviceNow).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Singular.
         * </p>
         * 
         * @param singular
         *        Specifies the information that is required for querying Singular.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singular(SingularSourceProperties singular);

        /**
         * <p>
         * Specifies the information that is required for querying Singular.
         * </p>
         * This is a convenience that creates an instance of the {@link SingularSourceProperties.Builder} avoiding the
         * need to create one manually via {@link SingularSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SingularSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #singular(SingularSourceProperties)}.
         * 
         * @param singular
         *        a consumer that will call methods on {@link SingularSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singular(SingularSourceProperties)
         */
        default Builder singular(Consumer<SingularSourceProperties.Builder> singular) {
            return singular(SingularSourceProperties.builder().applyMutation(singular).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Slack.
         * </p>
         * 
         * @param slack
         *        Specifies the information that is required for querying Slack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slack(SlackSourceProperties slack);

        /**
         * <p>
         * Specifies the information that is required for querying Slack.
         * </p>
         * This is a convenience that creates an instance of the {@link SlackSourceProperties.Builder} avoiding the need
         * to create one manually via {@link SlackSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlackSourceProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #slack(SlackSourceProperties)}.
         * 
         * @param slack
         *        a consumer that will call methods on {@link SlackSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slack(SlackSourceProperties)
         */
        default Builder slack(Consumer<SlackSourceProperties.Builder> slack) {
            return slack(SlackSourceProperties.builder().applyMutation(slack).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Trend Micro.
         * </p>
         * 
         * @param trendmicro
         *        Specifies the information that is required for querying Trend Micro.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendmicro(TrendmicroSourceProperties trendmicro);

        /**
         * <p>
         * Specifies the information that is required for querying Trend Micro.
         * </p>
         * This is a convenience that creates an instance of the {@link TrendmicroSourceProperties.Builder} avoiding the
         * need to create one manually via {@link TrendmicroSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrendmicroSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #trendmicro(TrendmicroSourceProperties)}.
         * 
         * @param trendmicro
         *        a consumer that will call methods on {@link TrendmicroSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendmicro(TrendmicroSourceProperties)
         */
        default Builder trendmicro(Consumer<TrendmicroSourceProperties.Builder> trendmicro) {
            return trendmicro(TrendmicroSourceProperties.builder().applyMutation(trendmicro).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Veeva.
         * </p>
         * 
         * @param veeva
         *        Specifies the information that is required for querying Veeva.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder veeva(VeevaSourceProperties veeva);

        /**
         * <p>
         * Specifies the information that is required for querying Veeva.
         * </p>
         * This is a convenience that creates an instance of the {@link VeevaSourceProperties.Builder} avoiding the need
         * to create one manually via {@link VeevaSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link VeevaSourceProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #veeva(VeevaSourceProperties)}.
         * 
         * @param veeva
         *        a consumer that will call methods on {@link VeevaSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #veeva(VeevaSourceProperties)
         */
        default Builder veeva(Consumer<VeevaSourceProperties.Builder> veeva) {
            return veeva(VeevaSourceProperties.builder().applyMutation(veeva).build());
        }

        /**
         * <p>
         * Specifies the information that is required for querying Zendesk.
         * </p>
         * 
         * @param zendesk
         *        Specifies the information that is required for querying Zendesk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zendesk(ZendeskSourceProperties zendesk);

        /**
         * <p>
         * Specifies the information that is required for querying Zendesk.
         * </p>
         * This is a convenience that creates an instance of the {@link ZendeskSourceProperties.Builder} avoiding the
         * need to create one manually via {@link ZendeskSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ZendeskSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #zendesk(ZendeskSourceProperties)}.
         * 
         * @param zendesk
         *        a consumer that will call methods on {@link ZendeskSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zendesk(ZendeskSourceProperties)
         */
        default Builder zendesk(Consumer<ZendeskSourceProperties.Builder> zendesk) {
            return zendesk(ZendeskSourceProperties.builder().applyMutation(zendesk).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmplitudeSourceProperties amplitude;

        private DatadogSourceProperties datadog;

        private DynatraceSourceProperties dynatrace;

        private GoogleAnalyticsSourceProperties googleAnalytics;

        private InforNexusSourceProperties inforNexus;

        private MarketoSourceProperties marketo;

        private S3SourceProperties s3;

        private SalesforceSourceProperties salesforce;

        private ServiceNowSourceProperties serviceNow;

        private SingularSourceProperties singular;

        private SlackSourceProperties slack;

        private TrendmicroSourceProperties trendmicro;

        private VeevaSourceProperties veeva;

        private ZendeskSourceProperties zendesk;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectorProperties model) {
            amplitude(model.amplitude);
            datadog(model.datadog);
            dynatrace(model.dynatrace);
            googleAnalytics(model.googleAnalytics);
            inforNexus(model.inforNexus);
            marketo(model.marketo);
            s3(model.s3);
            salesforce(model.salesforce);
            serviceNow(model.serviceNow);
            singular(model.singular);
            slack(model.slack);
            trendmicro(model.trendmicro);
            veeva(model.veeva);
            zendesk(model.zendesk);
        }

        public final AmplitudeSourceProperties.Builder getAmplitude() {
            return amplitude != null ? amplitude.toBuilder() : null;
        }

        @Override
        public final Builder amplitude(AmplitudeSourceProperties amplitude) {
            this.amplitude = amplitude;
            return this;
        }

        public final void setAmplitude(AmplitudeSourceProperties.BuilderImpl amplitude) {
            this.amplitude = amplitude != null ? amplitude.build() : null;
        }

        public final DatadogSourceProperties.Builder getDatadog() {
            return datadog != null ? datadog.toBuilder() : null;
        }

        @Override
        public final Builder datadog(DatadogSourceProperties datadog) {
            this.datadog = datadog;
            return this;
        }

        public final void setDatadog(DatadogSourceProperties.BuilderImpl datadog) {
            this.datadog = datadog != null ? datadog.build() : null;
        }

        public final DynatraceSourceProperties.Builder getDynatrace() {
            return dynatrace != null ? dynatrace.toBuilder() : null;
        }

        @Override
        public final Builder dynatrace(DynatraceSourceProperties dynatrace) {
            this.dynatrace = dynatrace;
            return this;
        }

        public final void setDynatrace(DynatraceSourceProperties.BuilderImpl dynatrace) {
            this.dynatrace = dynatrace != null ? dynatrace.build() : null;
        }

        public final GoogleAnalyticsSourceProperties.Builder getGoogleAnalytics() {
            return googleAnalytics != null ? googleAnalytics.toBuilder() : null;
        }

        @Override
        public final Builder googleAnalytics(GoogleAnalyticsSourceProperties googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
            return this;
        }

        public final void setGoogleAnalytics(GoogleAnalyticsSourceProperties.BuilderImpl googleAnalytics) {
            this.googleAnalytics = googleAnalytics != null ? googleAnalytics.build() : null;
        }

        public final InforNexusSourceProperties.Builder getInforNexus() {
            return inforNexus != null ? inforNexus.toBuilder() : null;
        }

        @Override
        public final Builder inforNexus(InforNexusSourceProperties inforNexus) {
            this.inforNexus = inforNexus;
            return this;
        }

        public final void setInforNexus(InforNexusSourceProperties.BuilderImpl inforNexus) {
            this.inforNexus = inforNexus != null ? inforNexus.build() : null;
        }

        public final MarketoSourceProperties.Builder getMarketo() {
            return marketo != null ? marketo.toBuilder() : null;
        }

        @Override
        public final Builder marketo(MarketoSourceProperties marketo) {
            this.marketo = marketo;
            return this;
        }

        public final void setMarketo(MarketoSourceProperties.BuilderImpl marketo) {
            this.marketo = marketo != null ? marketo.build() : null;
        }

        public final S3SourceProperties.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3SourceProperties s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3SourceProperties.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final SalesforceSourceProperties.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceSourceProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceSourceProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        public final ServiceNowSourceProperties.Builder getServiceNow() {
            return serviceNow != null ? serviceNow.toBuilder() : null;
        }

        @Override
        public final Builder serviceNow(ServiceNowSourceProperties serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        public final void setServiceNow(ServiceNowSourceProperties.BuilderImpl serviceNow) {
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
        }

        public final SingularSourceProperties.Builder getSingular() {
            return singular != null ? singular.toBuilder() : null;
        }

        @Override
        public final Builder singular(SingularSourceProperties singular) {
            this.singular = singular;
            return this;
        }

        public final void setSingular(SingularSourceProperties.BuilderImpl singular) {
            this.singular = singular != null ? singular.build() : null;
        }

        public final SlackSourceProperties.Builder getSlack() {
            return slack != null ? slack.toBuilder() : null;
        }

        @Override
        public final Builder slack(SlackSourceProperties slack) {
            this.slack = slack;
            return this;
        }

        public final void setSlack(SlackSourceProperties.BuilderImpl slack) {
            this.slack = slack != null ? slack.build() : null;
        }

        public final TrendmicroSourceProperties.Builder getTrendmicro() {
            return trendmicro != null ? trendmicro.toBuilder() : null;
        }

        @Override
        public final Builder trendmicro(TrendmicroSourceProperties trendmicro) {
            this.trendmicro = trendmicro;
            return this;
        }

        public final void setTrendmicro(TrendmicroSourceProperties.BuilderImpl trendmicro) {
            this.trendmicro = trendmicro != null ? trendmicro.build() : null;
        }

        public final VeevaSourceProperties.Builder getVeeva() {
            return veeva != null ? veeva.toBuilder() : null;
        }

        @Override
        public final Builder veeva(VeevaSourceProperties veeva) {
            this.veeva = veeva;
            return this;
        }

        public final void setVeeva(VeevaSourceProperties.BuilderImpl veeva) {
            this.veeva = veeva != null ? veeva.build() : null;
        }

        public final ZendeskSourceProperties.Builder getZendesk() {
            return zendesk != null ? zendesk.toBuilder() : null;
        }

        @Override
        public final Builder zendesk(ZendeskSourceProperties zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public final void setZendesk(ZendeskSourceProperties.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        public SourceConnectorProperties build() {
            return new SourceConnectorProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
