/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when ServiceNow is being used as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNowSourceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNowSourceProperties.Builder, ServiceNowSourceProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("object")
            .getter(getter(ServiceNowSourceProperties::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String object;

    private ServiceNowSourceProperties(BuilderImpl builder) {
        this.object = builder.object;
    }

    /**
     * <p>
     * The object specified in the ServiceNow flow source.
     * </p>
     * 
     * @return The object specified in the ServiceNow flow source.
     */
    public final String object() {
        return object;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(object());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowSourceProperties)) {
            return false;
        }
        ServiceNowSourceProperties other = (ServiceNowSourceProperties) obj;
        return Objects.equals(object(), other.object());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceNowSourceProperties").add("Object", object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "object":
            return Optional.ofNullable(clazz.cast(object()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowSourceProperties, T> g) {
        return obj -> g.apply((ServiceNowSourceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNowSourceProperties> {
        /**
         * <p>
         * The object specified in the ServiceNow flow source.
         * </p>
         * 
         * @param object
         *        The object specified in the ServiceNow flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);
    }

    static final class BuilderImpl implements Builder {
        private String object;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowSourceProperties model) {
            object(model.object);
        }

        public final String getObject() {
            return object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        public ServiceNowSourceProperties build() {
            return new ServiceNowSourceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
