/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details in the event of a failed flow, including the failure count and the related error messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorInfo implements SdkPojo, Serializable, ToCopyableBuilder<ErrorInfo.Builder, ErrorInfo> {
    private static final SdkField<Long> PUT_FAILURES_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("putFailuresCount").getter(getter(ErrorInfo::putFailuresCount)).setter(setter(Builder::putFailuresCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("putFailuresCount").build()).build();

    private static final SdkField<String> EXECUTION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionMessage").getter(getter(ErrorInfo::executionMessage)).setter(setter(Builder::executionMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUT_FAILURES_COUNT_FIELD,
            EXECUTION_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long putFailuresCount;

    private final String executionMessage;

    private ErrorInfo(BuilderImpl builder) {
        this.putFailuresCount = builder.putFailuresCount;
        this.executionMessage = builder.executionMessage;
    }

    /**
     * <p>
     * Specifies the failure count for the attempted flow.
     * </p>
     * 
     * @return Specifies the failure count for the attempted flow.
     */
    public final Long putFailuresCount() {
        return putFailuresCount;
    }

    /**
     * <p>
     * Specifies the error message that appears if a flow fails.
     * </p>
     * 
     * @return Specifies the error message that appears if a flow fails.
     */
    public final String executionMessage() {
        return executionMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(putFailuresCount());
        hashCode = 31 * hashCode + Objects.hashCode(executionMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo) obj;
        return Objects.equals(putFailuresCount(), other.putFailuresCount())
                && Objects.equals(executionMessage(), other.executionMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorInfo").add("PutFailuresCount", putFailuresCount())
                .add("ExecutionMessage", executionMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "putFailuresCount":
            return Optional.ofNullable(clazz.cast(putFailuresCount()));
        case "executionMessage":
            return Optional.ofNullable(clazz.cast(executionMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorInfo, T> g) {
        return obj -> g.apply((ErrorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorInfo> {
        /**
         * <p>
         * Specifies the failure count for the attempted flow.
         * </p>
         * 
         * @param putFailuresCount
         *        Specifies the failure count for the attempted flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putFailuresCount(Long putFailuresCount);

        /**
         * <p>
         * Specifies the error message that appears if a flow fails.
         * </p>
         * 
         * @param executionMessage
         *        Specifies the error message that appears if a flow fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionMessage(String executionMessage);
    }

    static final class BuilderImpl implements Builder {
        private Long putFailuresCount;

        private String executionMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInfo model) {
            putFailuresCount(model.putFailuresCount);
            executionMessage(model.executionMessage);
        }

        public final Long getPutFailuresCount() {
            return putFailuresCount;
        }

        @Override
        public final Builder putFailuresCount(Long putFailuresCount) {
            this.putFailuresCount = putFailuresCount;
            return this;
        }

        public final void setPutFailuresCount(Long putFailuresCount) {
            this.putFailuresCount = putFailuresCount;
        }

        public final String getExecutionMessage() {
            return executionMessage;
        }

        @Override
        public final Builder executionMessage(String executionMessage) {
            this.executionMessage = executionMessage;
            return this;
        }

        public final void setExecutionMessage(String executionMessage) {
            this.executionMessage = executionMessage;
        }

        @Override
        public ErrorInfo build() {
            return new ErrorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
