/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance of a connector. This includes the provided name, credentials ARN, connection-mode, and so on.
 * To keep the API intuitive and extensible, the fields that are common to all types of connector profiles are
 * explicitly specified at the top level. The rest of the connector-specific properties are available via the
 * <code>connectorProfileProperties</code> field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorProfile.Builder, ConnectorProfile> {
    private static final SdkField<String> CONNECTOR_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileArn").getter(getter(ConnectorProfile::connectorProfileArn))
            .setter(setter(Builder::connectorProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileArn").build())
            .build();

    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(ConnectorProfile::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(ConnectorProfile::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionMode").getter(getter(ConnectorProfile::connectionModeAsString))
            .setter(setter(Builder::connectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionMode").build()).build();

    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsArn").getter(getter(ConnectorProfile::credentialsArn))
            .setter(setter(Builder::credentialsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()).build();

    private static final SdkField<ConnectorProfileProperties> CONNECTOR_PROFILE_PROPERTIES_FIELD = SdkField
            .<ConnectorProfileProperties> builder(MarshallingType.SDK_POJO)
            .memberName("connectorProfileProperties")
            .getter(getter(ConnectorProfile::connectorProfileProperties))
            .setter(setter(Builder::connectorProfileProperties))
            .constructor(ConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileProperties").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ConnectorProfile::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(ConnectorProfile::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_ARN_FIELD,
            CONNECTOR_PROFILE_NAME_FIELD, CONNECTOR_TYPE_FIELD, CONNECTION_MODE_FIELD, CREDENTIALS_ARN_FIELD,
            CONNECTOR_PROFILE_PROPERTIES_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorProfileArn;

    private final String connectorProfileName;

    private final String connectorType;

    private final String connectionMode;

    private final String credentialsArn;

    private final ConnectorProfileProperties connectorProfileProperties;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private ConnectorProfile(BuilderImpl builder) {
        this.connectorProfileArn = builder.connectorProfileArn;
        this.connectorProfileName = builder.connectorProfileName;
        this.connectorType = builder.connectorType;
        this.connectionMode = builder.connectionMode;
        this.credentialsArn = builder.credentialsArn;
        this.connectorProfileProperties = builder.connectorProfileProperties;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector profile.
     */
    public final String connectorProfileArn() {
        return connectorProfileArn;
    }

    /**
     * <p>
     * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the AWS account.
     * </p>
     * 
     * @return The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the AWS
     *         account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * Indicates the connection mode and if it is public or private.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return Indicates the connection mode and if it is public or private.
     * @see ConnectionMode
     */
    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(connectionMode);
    }

    /**
     * <p>
     * Indicates the connection mode and if it is public or private.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return Indicates the connection mode and if it is public or private.
     * @see ConnectionMode
     */
    public final String connectionModeAsString() {
        return connectionMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector profile credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector profile credentials.
     */
    public final String credentialsArn() {
        return credentialsArn;
    }

    /**
     * <p>
     * The connector-specific properties of the profile configuration.
     * </p>
     * 
     * @return The connector-specific properties of the profile configuration.
     */
    public final ConnectorProfileProperties connectorProfileProperties() {
        return connectorProfileProperties;
    }

    /**
     * <p>
     * Specifies when the connector profile was created.
     * </p>
     * 
     * @return Specifies when the connector profile was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies when the connector profile was last updated.
     * </p>
     * 
     * @return Specifies when the connector profile was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileProperties());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorProfile)) {
            return false;
        }
        ConnectorProfile other = (ConnectorProfile) obj;
        return Objects.equals(connectorProfileArn(), other.connectorProfileArn())
                && Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectionModeAsString(), other.connectionModeAsString())
                && Objects.equals(credentialsArn(), other.credentialsArn())
                && Objects.equals(connectorProfileProperties(), other.connectorProfileProperties())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorProfile").add("ConnectorProfileArn", connectorProfileArn())
                .add("ConnectorProfileName", connectorProfileName()).add("ConnectorType", connectorTypeAsString())
                .add("ConnectionMode", connectionModeAsString()).add("CredentialsArn", credentialsArn())
                .add("ConnectorProfileProperties", connectorProfileProperties()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileArn":
            return Optional.ofNullable(clazz.cast(connectorProfileArn()));
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectionMode":
            return Optional.ofNullable(clazz.cast(connectionModeAsString()));
        case "credentialsArn":
            return Optional.ofNullable(clazz.cast(credentialsArn()));
        case "connectorProfileProperties":
            return Optional.ofNullable(clazz.cast(connectorProfileProperties()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorProfile, T> g) {
        return obj -> g.apply((ConnectorProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorProfile> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector profile.
         * </p>
         * 
         * @param connectorProfileArn
         *        The Amazon Resource Name (ARN) of the connector profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileArn(String connectorProfileArn);

        /**
         * <p>
         * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the AWS
         * account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
         *        AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * Indicates the connection mode and if it is public or private.
         * </p>
         * 
         * @param connectionMode
         *        Indicates the connection mode and if it is public or private.
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(String connectionMode);

        /**
         * <p>
         * Indicates the connection mode and if it is public or private.
         * </p>
         * 
         * @param connectionMode
         *        Indicates the connection mode and if it is public or private.
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(ConnectionMode connectionMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector profile credentials.
         * </p>
         * 
         * @param credentialsArn
         *        The Amazon Resource Name (ARN) of the connector profile credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsArn(String credentialsArn);

        /**
         * <p>
         * The connector-specific properties of the profile configuration.
         * </p>
         * 
         * @param connectorProfileProperties
         *        The connector-specific properties of the profile configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileProperties(ConnectorProfileProperties connectorProfileProperties);

        /**
         * <p>
         * The connector-specific properties of the profile configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectorProfileProperties.Builder} avoiding the
         * need to create one manually via {@link ConnectorProfileProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectorProfileProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #connectorProfileProperties(ConnectorProfileProperties)}.
         * 
         * @param connectorProfileProperties
         *        a consumer that will call methods on {@link ConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProfileProperties(ConnectorProfileProperties)
         */
        default Builder connectorProfileProperties(Consumer<ConnectorProfileProperties.Builder> connectorProfileProperties) {
            return connectorProfileProperties(ConnectorProfileProperties.builder().applyMutation(connectorProfileProperties)
                    .build());
        }

        /**
         * <p>
         * Specifies when the connector profile was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies when the connector profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies when the connector profile was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies when the connector profile was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String connectorProfileArn;

        private String connectorProfileName;

        private String connectorType;

        private String connectionMode;

        private String credentialsArn;

        private ConnectorProfileProperties connectorProfileProperties;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorProfile model) {
            connectorProfileArn(model.connectorProfileArn);
            connectorProfileName(model.connectorProfileName);
            connectorType(model.connectorType);
            connectionMode(model.connectionMode);
            credentialsArn(model.credentialsArn);
            connectorProfileProperties(model.connectorProfileProperties);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getConnectorProfileArn() {
            return connectorProfileArn;
        }

        @Override
        public final Builder connectorProfileArn(String connectorProfileArn) {
            this.connectorProfileArn = connectorProfileArn;
            return this;
        }

        public final void setConnectorProfileArn(String connectorProfileArn) {
            this.connectorProfileArn = connectorProfileArn;
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final String getConnectionMode() {
            return connectionMode;
        }

        @Override
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        public final String getCredentialsArn() {
            return credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        public final ConnectorProfileProperties.Builder getConnectorProfileProperties() {
            return connectorProfileProperties != null ? connectorProfileProperties.toBuilder() : null;
        }

        @Override
        public final Builder connectorProfileProperties(ConnectorProfileProperties connectorProfileProperties) {
            this.connectorProfileProperties = connectorProfileProperties;
            return this;
        }

        public final void setConnectorProfileProperties(ConnectorProfileProperties.BuilderImpl connectorProfileProperties) {
            this.connectorProfileProperties = connectorProfileProperties != null ? connectorProfileProperties.build() : null;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public ConnectorProfile build() {
            return new ConnectorProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
