/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import static java.util.stream.Collectors.toMap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ConnectorConfigurationsMapCopier {
    static Map<String, ConnectorConfiguration> copy(Map<String, ConnectorConfiguration> connectorConfigurationsMapParam) {
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, ConnectorConfiguration> connectorConfigurationsMapParamCopy = connectorConfigurationsMapParam.entrySet()
                .stream().collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
        return Collections.unmodifiableMap(connectorConfigurationsMapParamCopy);
    }

    static Map<String, ConnectorConfiguration> copyFromBuilder(
            Map<String, ? extends ConnectorConfiguration.Builder> connectorConfigurationsMapParam) {
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof DefaultSdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        return copy(connectorConfigurationsMapParam.entrySet().stream()
                .collect(toMap(Map.Entry::getKey, e -> e.getValue().build())));
    }

    static Map<String, ConnectorConfiguration> copyEnumToString(
            Map<ConnectorType, ConnectorConfiguration> connectorConfigurationsMapParam) {
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, ConnectorConfiguration> connectorConfigurationsMapParamCopy = connectorConfigurationsMapParam.entrySet()
                .stream().collect(HashMap::new, (m, e) -> m.put(e.getKey().toString(), e.getValue()), HashMap::putAll);
        return Collections.unmodifiableMap(connectorConfigurationsMapParamCopy);
    }

    static Map<ConnectorType, ConnectorConfiguration> copyStringToEnum(
            Map<String, ConnectorConfiguration> connectorConfigurationsMapParam) {
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<ConnectorType, ConnectorConfiguration> connectorConfigurationsMapParamCopy = connectorConfigurationsMapParam
                .entrySet().stream().collect(HashMap::new, (m, e) -> {
                    ConnectorType keyAsEnum = ConnectorType.fromValue(e.getKey());
                    if (keyAsEnum != ConnectorType.UNKNOWN_TO_SDK_VERSION) {
                        m.put(keyAsEnum, e.getValue());
                    }
                }, HashMap::putAll);
        return Collections.unmodifiableMap(connectorConfigurationsMapParamCopy);
    }
}
