/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings related to a given connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorConfiguration.Builder, ConnectorConfiguration> {
    private static final SdkField<Boolean> CAN_USE_AS_SOURCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canUseAsSource").getter(getter(ConnectorConfiguration::canUseAsSource))
            .setter(setter(Builder::canUseAsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsSource").build()).build();

    private static final SdkField<Boolean> CAN_USE_AS_DESTINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canUseAsDestination").getter(getter(ConnectorConfiguration::canUseAsDestination))
            .setter(setter(Builder::canUseAsDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsDestination").build())
            .build();

    private static final SdkField<List<String>> SUPPORTED_DESTINATION_CONNECTORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedDestinationConnectors")
            .getter(getter(ConnectorConfiguration::supportedDestinationConnectorsAsStrings))
            .setter(setter(Builder::supportedDestinationConnectorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDestinationConnectors")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_SCHEDULING_FREQUENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedSchedulingFrequencies")
            .getter(getter(ConnectorConfiguration::supportedSchedulingFrequenciesAsStrings))
            .setter(setter(Builder::supportedSchedulingFrequenciesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedSchedulingFrequencies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPrivateLinkEnabled").getter(getter(ConnectorConfiguration::isPrivateLinkEnabled))
            .setter(setter(Builder::isPrivateLinkEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEnabled").build())
            .build();

    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPrivateLinkEndpointUrlRequired")
            .getter(getter(ConnectorConfiguration::isPrivateLinkEndpointUrlRequired))
            .setter(setter(Builder::isPrivateLinkEndpointUrlRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEndpointUrlRequired")
                    .build()).build();

    private static final SdkField<List<String>> SUPPORTED_TRIGGER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedTriggerTypes")
            .getter(getter(ConnectorConfiguration::supportedTriggerTypesAsStrings))
            .setter(setter(Builder::supportedTriggerTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedTriggerTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConnectorMetadata> CONNECTOR_METADATA_FIELD = SdkField
            .<ConnectorMetadata> builder(MarshallingType.SDK_POJO).memberName("connectorMetadata")
            .getter(getter(ConnectorConfiguration::connectorMetadata)).setter(setter(Builder::connectorMetadata))
            .constructor(ConnectorMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_USE_AS_SOURCE_FIELD,
            CAN_USE_AS_DESTINATION_FIELD, SUPPORTED_DESTINATION_CONNECTORS_FIELD, SUPPORTED_SCHEDULING_FREQUENCIES_FIELD,
            IS_PRIVATE_LINK_ENABLED_FIELD, IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD, SUPPORTED_TRIGGER_TYPES_FIELD,
            CONNECTOR_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean canUseAsSource;

    private final Boolean canUseAsDestination;

    private final List<String> supportedDestinationConnectors;

    private final List<String> supportedSchedulingFrequencies;

    private final Boolean isPrivateLinkEnabled;

    private final Boolean isPrivateLinkEndpointUrlRequired;

    private final List<String> supportedTriggerTypes;

    private final ConnectorMetadata connectorMetadata;

    private ConnectorConfiguration(BuilderImpl builder) {
        this.canUseAsSource = builder.canUseAsSource;
        this.canUseAsDestination = builder.canUseAsDestination;
        this.supportedDestinationConnectors = builder.supportedDestinationConnectors;
        this.supportedSchedulingFrequencies = builder.supportedSchedulingFrequencies;
        this.isPrivateLinkEnabled = builder.isPrivateLinkEnabled;
        this.isPrivateLinkEndpointUrlRequired = builder.isPrivateLinkEndpointUrlRequired;
        this.supportedTriggerTypes = builder.supportedTriggerTypes;
        this.connectorMetadata = builder.connectorMetadata;
    }

    /**
     * <p>
     * Specifies whether the connector can be used as a source.
     * </p>
     * 
     * @return Specifies whether the connector can be used as a source.
     */
    public final Boolean canUseAsSource() {
        return canUseAsSource;
    }

    /**
     * <p>
     * Specifies whether the connector can be used as a destination.
     * </p>
     * 
     * @return Specifies whether the connector can be used as a destination.
     */
    public final Boolean canUseAsDestination() {
        return canUseAsDestination;
    }

    /**
     * <p>
     * Lists the connectors that are available for use as destinations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedDestinationConnectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists the connectors that are available for use as destinations.
     */
    public final List<ConnectorType> supportedDestinationConnectors() {
        return ConnectorTypeListCopier.copyStringToEnum(supportedDestinationConnectors);
    }

    /**
     * Returns true if the SupportedDestinationConnectors property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasSupportedDestinationConnectors() {
        return supportedDestinationConnectors != null && !(supportedDestinationConnectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the connectors that are available for use as destinations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedDestinationConnectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists the connectors that are available for use as destinations.
     */
    public final List<String> supportedDestinationConnectorsAsStrings() {
        return supportedDestinationConnectors;
    }

    /**
     * <p>
     * Specifies the supported flow frequency for that connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedSchedulingFrequencies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the supported flow frequency for that connector.
     */
    public final List<ScheduleFrequencyType> supportedSchedulingFrequencies() {
        return SchedulingFrequencyTypeListCopier.copyStringToEnum(supportedSchedulingFrequencies);
    }

    /**
     * Returns true if the SupportedSchedulingFrequencies property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasSupportedSchedulingFrequencies() {
        return supportedSchedulingFrequencies != null && !(supportedSchedulingFrequencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the supported flow frequency for that connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedSchedulingFrequencies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the supported flow frequency for that connector.
     */
    public final List<String> supportedSchedulingFrequenciesAsStrings() {
        return supportedSchedulingFrequencies;
    }

    /**
     * <p>
     * Specifies if PrivateLink is enabled for that connector.
     * </p>
     * 
     * @return Specifies if PrivateLink is enabled for that connector.
     */
    public final Boolean isPrivateLinkEnabled() {
        return isPrivateLinkEnabled;
    }

    /**
     * <p>
     * Specifies if a PrivateLink endpoint URL is required.
     * </p>
     * 
     * @return Specifies if a PrivateLink endpoint URL is required.
     */
    public final Boolean isPrivateLinkEndpointUrlRequired() {
        return isPrivateLinkEndpointUrlRequired;
    }

    /**
     * <p>
     * Specifies the supported trigger types for the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedTriggerTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the supported trigger types for the flow.
     */
    public final List<TriggerType> supportedTriggerTypes() {
        return TriggerTypeListCopier.copyStringToEnum(supportedTriggerTypes);
    }

    /**
     * Returns true if the SupportedTriggerTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedTriggerTypes() {
        return supportedTriggerTypes != null && !(supportedTriggerTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the supported trigger types for the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedTriggerTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the supported trigger types for the flow.
     */
    public final List<String> supportedTriggerTypesAsStrings() {
        return supportedTriggerTypes;
    }

    /**
     * <p>
     * Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
     * <code>privateLinkServiceUrl</code>, and so on.
     * </p>
     * 
     * @return Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
     *         <code>privateLinkServiceUrl</code>, and so on.
     */
    public final ConnectorMetadata connectorMetadata() {
        return connectorMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canUseAsSource());
        hashCode = 31 * hashCode + Objects.hashCode(canUseAsDestination());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedDestinationConnectors() ? supportedDestinationConnectorsAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedSchedulingFrequencies() ? supportedSchedulingFrequenciesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isPrivateLinkEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(isPrivateLinkEndpointUrlRequired());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedTriggerTypes() ? supportedTriggerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfiguration)) {
            return false;
        }
        ConnectorConfiguration other = (ConnectorConfiguration) obj;
        return Objects.equals(canUseAsSource(), other.canUseAsSource())
                && Objects.equals(canUseAsDestination(), other.canUseAsDestination())
                && hasSupportedDestinationConnectors() == other.hasSupportedDestinationConnectors()
                && Objects.equals(supportedDestinationConnectorsAsStrings(), other.supportedDestinationConnectorsAsStrings())
                && hasSupportedSchedulingFrequencies() == other.hasSupportedSchedulingFrequencies()
                && Objects.equals(supportedSchedulingFrequenciesAsStrings(), other.supportedSchedulingFrequenciesAsStrings())
                && Objects.equals(isPrivateLinkEnabled(), other.isPrivateLinkEnabled())
                && Objects.equals(isPrivateLinkEndpointUrlRequired(), other.isPrivateLinkEndpointUrlRequired())
                && hasSupportedTriggerTypes() == other.hasSupportedTriggerTypes()
                && Objects.equals(supportedTriggerTypesAsStrings(), other.supportedTriggerTypesAsStrings())
                && Objects.equals(connectorMetadata(), other.connectorMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConnectorConfiguration")
                .add("CanUseAsSource", canUseAsSource())
                .add("CanUseAsDestination", canUseAsDestination())
                .add("SupportedDestinationConnectors",
                        hasSupportedDestinationConnectors() ? supportedDestinationConnectorsAsStrings() : null)
                .add("SupportedSchedulingFrequencies",
                        hasSupportedSchedulingFrequencies() ? supportedSchedulingFrequenciesAsStrings() : null)
                .add("IsPrivateLinkEnabled", isPrivateLinkEnabled())
                .add("IsPrivateLinkEndpointUrlRequired", isPrivateLinkEndpointUrlRequired())
                .add("SupportedTriggerTypes", hasSupportedTriggerTypes() ? supportedTriggerTypesAsStrings() : null)
                .add("ConnectorMetadata", connectorMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "canUseAsSource":
            return Optional.ofNullable(clazz.cast(canUseAsSource()));
        case "canUseAsDestination":
            return Optional.ofNullable(clazz.cast(canUseAsDestination()));
        case "supportedDestinationConnectors":
            return Optional.ofNullable(clazz.cast(supportedDestinationConnectorsAsStrings()));
        case "supportedSchedulingFrequencies":
            return Optional.ofNullable(clazz.cast(supportedSchedulingFrequenciesAsStrings()));
        case "isPrivateLinkEnabled":
            return Optional.ofNullable(clazz.cast(isPrivateLinkEnabled()));
        case "isPrivateLinkEndpointUrlRequired":
            return Optional.ofNullable(clazz.cast(isPrivateLinkEndpointUrlRequired()));
        case "supportedTriggerTypes":
            return Optional.ofNullable(clazz.cast(supportedTriggerTypesAsStrings()));
        case "connectorMetadata":
            return Optional.ofNullable(clazz.cast(connectorMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorConfiguration, T> g) {
        return obj -> g.apply((ConnectorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorConfiguration> {
        /**
         * <p>
         * Specifies whether the connector can be used as a source.
         * </p>
         * 
         * @param canUseAsSource
         *        Specifies whether the connector can be used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canUseAsSource(Boolean canUseAsSource);

        /**
         * <p>
         * Specifies whether the connector can be used as a destination.
         * </p>
         * 
         * @param canUseAsDestination
         *        Specifies whether the connector can be used as a destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canUseAsDestination(Boolean canUseAsDestination);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectorsWithStrings(Collection<String> supportedDestinationConnectors);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectorsWithStrings(String... supportedDestinationConnectors);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectors(Collection<ConnectorType> supportedDestinationConnectors);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectors(ConnectorType... supportedDestinationConnectors);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequenciesWithStrings(Collection<String> supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequenciesWithStrings(String... supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequencies(ScheduleFrequencyType... supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies if PrivateLink is enabled for that connector.
         * </p>
         * 
         * @param isPrivateLinkEnabled
         *        Specifies if PrivateLink is enabled for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrivateLinkEnabled(Boolean isPrivateLinkEnabled);

        /**
         * <p>
         * Specifies if a PrivateLink endpoint URL is required.
         * </p>
         * 
         * @param isPrivateLinkEndpointUrlRequired
         *        Specifies if a PrivateLink endpoint URL is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypesWithStrings(Collection<String> supportedTriggerTypes);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypesWithStrings(String... supportedTriggerTypes);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypes(Collection<TriggerType> supportedTriggerTypes);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypes(TriggerType... supportedTriggerTypes);

        /**
         * <p>
         * Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
         * <code>privateLinkServiceUrl</code>, and so on.
         * </p>
         * 
         * @param connectorMetadata
         *        Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
         *        <code>privateLinkServiceUrl</code>, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorMetadata(ConnectorMetadata connectorMetadata);

        /**
         * <p>
         * Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
         * <code>privateLinkServiceUrl</code>, and so on.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectorMetadata.Builder} avoiding the need to
         * create one manually via {@link ConnectorMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectorMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #connectorMetadata(ConnectorMetadata)}.
         * 
         * @param connectorMetadata
         *        a consumer that will call methods on {@link ConnectorMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorMetadata(ConnectorMetadata)
         */
        default Builder connectorMetadata(Consumer<ConnectorMetadata.Builder> connectorMetadata) {
            return connectorMetadata(ConnectorMetadata.builder().applyMutation(connectorMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean canUseAsSource;

        private Boolean canUseAsDestination;

        private List<String> supportedDestinationConnectors = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedSchedulingFrequencies = DefaultSdkAutoConstructList.getInstance();

        private Boolean isPrivateLinkEnabled;

        private Boolean isPrivateLinkEndpointUrlRequired;

        private List<String> supportedTriggerTypes = DefaultSdkAutoConstructList.getInstance();

        private ConnectorMetadata connectorMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorConfiguration model) {
            canUseAsSource(model.canUseAsSource);
            canUseAsDestination(model.canUseAsDestination);
            supportedDestinationConnectorsWithStrings(model.supportedDestinationConnectors);
            supportedSchedulingFrequenciesWithStrings(model.supportedSchedulingFrequencies);
            isPrivateLinkEnabled(model.isPrivateLinkEnabled);
            isPrivateLinkEndpointUrlRequired(model.isPrivateLinkEndpointUrlRequired);
            supportedTriggerTypesWithStrings(model.supportedTriggerTypes);
            connectorMetadata(model.connectorMetadata);
        }

        public final Boolean getCanUseAsSource() {
            return canUseAsSource;
        }

        @Override
        public final Builder canUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
            return this;
        }

        public final void setCanUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
        }

        public final Boolean getCanUseAsDestination() {
            return canUseAsDestination;
        }

        @Override
        public final Builder canUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
            return this;
        }

        public final void setCanUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
        }

        public final Collection<String> getSupportedDestinationConnectors() {
            if (supportedDestinationConnectors instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedDestinationConnectors;
        }

        @Override
        public final Builder supportedDestinationConnectorsWithStrings(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectorsWithStrings(String... supportedDestinationConnectors) {
            supportedDestinationConnectorsWithStrings(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        @Override
        public final Builder supportedDestinationConnectors(Collection<ConnectorType> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copyEnumToString(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectors(ConnectorType... supportedDestinationConnectors) {
            supportedDestinationConnectors(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        public final void setSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
        }

        public final Collection<String> getSupportedSchedulingFrequencies() {
            if (supportedSchedulingFrequencies instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedSchedulingFrequencies;
        }

        @Override
        public final Builder supportedSchedulingFrequenciesWithStrings(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequenciesWithStrings(String... supportedSchedulingFrequencies) {
            supportedSchedulingFrequenciesWithStrings(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        @Override
        public final Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier
                    .copyEnumToString(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequencies(ScheduleFrequencyType... supportedSchedulingFrequencies) {
            supportedSchedulingFrequencies(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        public final void setSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
        }

        public final Boolean getIsPrivateLinkEnabled() {
            return isPrivateLinkEnabled;
        }

        @Override
        public final Builder isPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
            return this;
        }

        public final void setIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
        }

        public final Boolean getIsPrivateLinkEndpointUrlRequired() {
            return isPrivateLinkEndpointUrlRequired;
        }

        @Override
        public final Builder isPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
            return this;
        }

        public final void setIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
        }

        public final Collection<String> getSupportedTriggerTypes() {
            if (supportedTriggerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedTriggerTypes;
        }

        @Override
        public final Builder supportedTriggerTypesWithStrings(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypesWithStrings(String... supportedTriggerTypes) {
            supportedTriggerTypesWithStrings(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        @Override
        public final Builder supportedTriggerTypes(Collection<TriggerType> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copyEnumToString(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypes(TriggerType... supportedTriggerTypes) {
            supportedTriggerTypes(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        public final void setSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
        }

        public final ConnectorMetadata.Builder getConnectorMetadata() {
            return connectorMetadata != null ? connectorMetadata.toBuilder() : null;
        }

        @Override
        public final Builder connectorMetadata(ConnectorMetadata connectorMetadata) {
            this.connectorMetadata = connectorMetadata;
            return this;
        }

        public final void setConnectorMetadata(ConnectorMetadata.BuilderImpl connectorMetadata) {
            this.connectorMetadata = connectorMetadata != null ? connectorMetadata.build() : null;
        }

        @Override
        public ConnectorConfiguration build() {
            return new ConnectorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
