/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AggregationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationConfig> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregationConfig.getter(AggregationConfig::aggregationTypeAsString)).setter(AggregationConfig.setter(Builder::aggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aggregationType;

    private AggregationConfig(BuilderImpl builder) {
        this.aggregationType = builder.aggregationType;
    }

    public AggregationType aggregationType() {
        return AggregationType.fromValue(this.aggregationType);
    }

    public String aggregationTypeAsString() {
        return this.aggregationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationConfig)) {
            return false;
        }
        AggregationConfig other = (AggregationConfig)obj;
        return Objects.equals(this.aggregationTypeAsString(), other.aggregationTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AggregationConfig").add("AggregationType", (Object)this.aggregationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationConfig, T> g) {
        return obj -> g.apply((AggregationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationConfig model) {
            this.aggregationType(model.aggregationType);
        }

        public final String getAggregationType() {
            return this.aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        public AggregationConfig build() {
            return new AggregationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationConfig> {
        public Builder aggregationType(String var1);

        public Builder aggregationType(AggregationType var1);
    }
}

