/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionDetails> {
    private static final SdkField<String> MOST_RECENT_EXECUTION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecutionDetails.getter(ExecutionDetails::mostRecentExecutionMessage)).setter(ExecutionDetails.setter(Builder::mostRecentExecutionMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionMessage").build()}).build();
    private static final SdkField<Instant> MOST_RECENT_EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ExecutionDetails.getter(ExecutionDetails::mostRecentExecutionTime)).setter(ExecutionDetails.setter(Builder::mostRecentExecutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionTime").build()}).build();
    private static final SdkField<String> MOST_RECENT_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecutionDetails.getter(ExecutionDetails::mostRecentExecutionStatusAsString)).setter(ExecutionDetails.setter(Builder::mostRecentExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentExecutionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOST_RECENT_EXECUTION_MESSAGE_FIELD, MOST_RECENT_EXECUTION_TIME_FIELD, MOST_RECENT_EXECUTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mostRecentExecutionMessage;
    private final Instant mostRecentExecutionTime;
    private final String mostRecentExecutionStatus;

    private ExecutionDetails(BuilderImpl builder) {
        this.mostRecentExecutionMessage = builder.mostRecentExecutionMessage;
        this.mostRecentExecutionTime = builder.mostRecentExecutionTime;
        this.mostRecentExecutionStatus = builder.mostRecentExecutionStatus;
    }

    public String mostRecentExecutionMessage() {
        return this.mostRecentExecutionMessage;
    }

    public Instant mostRecentExecutionTime() {
        return this.mostRecentExecutionTime;
    }

    public ExecutionStatus mostRecentExecutionStatus() {
        return ExecutionStatus.fromValue(this.mostRecentExecutionStatus);
    }

    public String mostRecentExecutionStatusAsString() {
        return this.mostRecentExecutionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mostRecentExecutionMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.mostRecentExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.mostRecentExecutionStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionDetails)) {
            return false;
        }
        ExecutionDetails other = (ExecutionDetails)obj;
        return Objects.equals(this.mostRecentExecutionMessage(), other.mostRecentExecutionMessage()) && Objects.equals(this.mostRecentExecutionTime(), other.mostRecentExecutionTime()) && Objects.equals(this.mostRecentExecutionStatusAsString(), other.mostRecentExecutionStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ExecutionDetails").add("MostRecentExecutionMessage", (Object)this.mostRecentExecutionMessage()).add("MostRecentExecutionTime", (Object)this.mostRecentExecutionTime()).add("MostRecentExecutionStatus", (Object)this.mostRecentExecutionStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mostRecentExecutionMessage": {
                return Optional.ofNullable(clazz.cast(this.mostRecentExecutionMessage()));
            }
            case "mostRecentExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.mostRecentExecutionTime()));
            }
            case "mostRecentExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.mostRecentExecutionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionDetails, T> g) {
        return obj -> g.apply((ExecutionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mostRecentExecutionMessage;
        private Instant mostRecentExecutionTime;
        private String mostRecentExecutionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionDetails model) {
            this.mostRecentExecutionMessage(model.mostRecentExecutionMessage);
            this.mostRecentExecutionTime(model.mostRecentExecutionTime);
            this.mostRecentExecutionStatus(model.mostRecentExecutionStatus);
        }

        public final String getMostRecentExecutionMessage() {
            return this.mostRecentExecutionMessage;
        }

        @Override
        public final Builder mostRecentExecutionMessage(String mostRecentExecutionMessage) {
            this.mostRecentExecutionMessage = mostRecentExecutionMessage;
            return this;
        }

        public final void setMostRecentExecutionMessage(String mostRecentExecutionMessage) {
            this.mostRecentExecutionMessage = mostRecentExecutionMessage;
        }

        public final Instant getMostRecentExecutionTime() {
            return this.mostRecentExecutionTime;
        }

        @Override
        public final Builder mostRecentExecutionTime(Instant mostRecentExecutionTime) {
            this.mostRecentExecutionTime = mostRecentExecutionTime;
            return this;
        }

        public final void setMostRecentExecutionTime(Instant mostRecentExecutionTime) {
            this.mostRecentExecutionTime = mostRecentExecutionTime;
        }

        public final String getMostRecentExecutionStatus() {
            return this.mostRecentExecutionStatus;
        }

        @Override
        public final Builder mostRecentExecutionStatus(String mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus = mostRecentExecutionStatus;
            return this;
        }

        @Override
        public final Builder mostRecentExecutionStatus(ExecutionStatus mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus(mostRecentExecutionStatus == null ? null : mostRecentExecutionStatus.toString());
            return this;
        }

        public final void setMostRecentExecutionStatus(String mostRecentExecutionStatus) {
            this.mostRecentExecutionStatus = mostRecentExecutionStatus;
        }

        public ExecutionDetails build() {
            return new ExecutionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionDetails> {
        public Builder mostRecentExecutionMessage(String var1);

        public Builder mostRecentExecutionTime(Instant var1);

        public Builder mostRecentExecutionStatus(String var1);

        public Builder mostRecentExecutionStatus(ExecutionStatus var1);
    }
}

