/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appfabric.model.AppFabricRequest;
import software.amazon.awssdk.services.appfabric.model.TaskIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetUserAccessTasksRequest
extends AppFabricRequest
implements ToCopyableBuilder<Builder, BatchGetUserAccessTasksRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleIdentifier").getter(BatchGetUserAccessTasksRequest.getter(BatchGetUserAccessTasksRequest::appBundleIdentifier)).setter(BatchGetUserAccessTasksRequest.setter(Builder::appBundleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundleIdentifier").build()}).build();
    private static final SdkField<List<String>> TASK_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskIdList").getter(BatchGetUserAccessTasksRequest.getter(BatchGetUserAccessTasksRequest::taskIdList)).setter(BatchGetUserAccessTasksRequest.setter(Builder::taskIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD, TASK_ID_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetUserAccessTasksRequest.memberNameToFieldInitializer();
    private final String appBundleIdentifier;
    private final List<String> taskIdList;

    private BatchGetUserAccessTasksRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.taskIdList = builder.taskIdList;
    }

    public final String appBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public final boolean hasTaskIdList() {
        return this.taskIdList != null && !(this.taskIdList instanceof SdkAutoConstructList);
    }

    public final List<String> taskIdList() {
        return this.taskIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskIdList() ? this.taskIdList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetUserAccessTasksRequest)) {
            return false;
        }
        BatchGetUserAccessTasksRequest other = (BatchGetUserAccessTasksRequest)((Object)obj);
        return Objects.equals(this.appBundleIdentifier(), other.appBundleIdentifier()) && this.hasTaskIdList() == other.hasTaskIdList() && Objects.equals(this.taskIdList(), other.taskIdList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetUserAccessTasksRequest").add("AppBundleIdentifier", (Object)this.appBundleIdentifier()).add("TaskIdList", this.hasTaskIdList() ? this.taskIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appBundleIdentifier()));
            }
            case "taskIdList": {
                return Optional.ofNullable(clazz.cast(this.taskIdList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("taskIdList", TASK_ID_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetUserAccessTasksRequest, T> g) {
        return obj -> g.apply((BatchGetUserAccessTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricRequest.BuilderImpl
    implements Builder {
        private String appBundleIdentifier;
        private List<String> taskIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetUserAccessTasksRequest model) {
            super(model);
            this.appBundleIdentifier(model.appBundleIdentifier);
            this.taskIdList(model.taskIdList);
        }

        public final String getAppBundleIdentifier() {
            return this.appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final Collection<String> getTaskIdList() {
            if (this.taskIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskIdList;
        }

        public final void setTaskIdList(Collection<String> taskIdList) {
            this.taskIdList = TaskIdListCopier.copy(taskIdList);
        }

        @Override
        public final Builder taskIdList(Collection<String> taskIdList) {
            this.taskIdList = TaskIdListCopier.copy(taskIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIdList(String ... taskIdList) {
            this.taskIdList(Arrays.asList(taskIdList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetUserAccessTasksRequest build() {
            return new BatchGetUserAccessTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetUserAccessTasksRequest> {
        public Builder appBundleIdentifier(String var1);

        public Builder taskIdList(Collection<String> var1);

        public Builder taskIdList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

