/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appfabric.AppFabricClient;
import software.amazon.awssdk.services.appfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.appfabric.model.IngestionDestinationSummary;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse;

public class ListIngestionDestinationsIterable
implements SdkIterable<ListIngestionDestinationsResponse> {
    private final AppFabricClient client;
    private final ListIngestionDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIngestionDestinationsIterable(AppFabricClient client, ListIngestionDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIngestionDestinationsResponseFetcher();
    }

    public Iterator<ListIngestionDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IngestionDestinationSummary> ingestionDestinations() {
        Function<ListIngestionDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingestionDestinations() != null) {
                return response.ingestionDestinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIngestionDestinationsResponseFetcher
    implements SyncPageFetcher<ListIngestionDestinationsResponse> {
        private ListIngestionDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestionDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIngestionDestinationsResponse nextPage(ListIngestionDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestionDestinationsIterable.this.client.listIngestionDestinations(ListIngestionDestinationsIterable.this.firstRequest);
            }
            return ListIngestionDestinationsIterable.this.client.listIngestionDestinations((ListIngestionDestinationsRequest)((Object)ListIngestionDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

