/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appfabric.model.AppFabricResponse;
import software.amazon.awssdk.services.appfabric.model.IngestionDestinationListCopier;
import software.amazon.awssdk.services.appfabric.model.IngestionDestinationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIngestionDestinationsResponse
extends AppFabricResponse
implements ToCopyableBuilder<Builder, ListIngestionDestinationsResponse> {
    private static final SdkField<List<IngestionDestinationSummary>> INGESTION_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ingestionDestinations").getter(ListIngestionDestinationsResponse.getter(ListIngestionDestinationsResponse::ingestionDestinations)).setter(ListIngestionDestinationsResponse.setter(Builder::ingestionDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngestionDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIngestionDestinationsResponse.getter(ListIngestionDestinationsResponse::nextToken)).setter(ListIngestionDestinationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_DESTINATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IngestionDestinationSummary> ingestionDestinations;
    private final String nextToken;

    private ListIngestionDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.ingestionDestinations = builder.ingestionDestinations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIngestionDestinations() {
        return this.ingestionDestinations != null && !(this.ingestionDestinations instanceof SdkAutoConstructList);
    }

    public final List<IngestionDestinationSummary> ingestionDestinations() {
        return this.ingestionDestinations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngestionDestinations() ? this.ingestionDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionDestinationsResponse)) {
            return false;
        }
        ListIngestionDestinationsResponse other = (ListIngestionDestinationsResponse)((Object)obj);
        return this.hasIngestionDestinations() == other.hasIngestionDestinations() && Objects.equals(this.ingestionDestinations(), other.ingestionDestinations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIngestionDestinationsResponse").add("IngestionDestinations", this.hasIngestionDestinations() ? this.ingestionDestinations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ingestionDestinations": {
                return Optional.ofNullable(clazz.cast(this.ingestionDestinations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIngestionDestinationsResponse, T> g) {
        return obj -> g.apply((ListIngestionDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricResponse.BuilderImpl
    implements Builder {
        private List<IngestionDestinationSummary> ingestionDestinations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestionDestinationsResponse model) {
            super(model);
            this.ingestionDestinations(model.ingestionDestinations);
            this.nextToken(model.nextToken);
        }

        public final List<IngestionDestinationSummary.Builder> getIngestionDestinations() {
            List<IngestionDestinationSummary.Builder> result = IngestionDestinationListCopier.copyToBuilder(this.ingestionDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngestionDestinations(Collection<IngestionDestinationSummary.BuilderImpl> ingestionDestinations) {
            this.ingestionDestinations = IngestionDestinationListCopier.copyFromBuilder(ingestionDestinations);
        }

        @Override
        public final Builder ingestionDestinations(Collection<IngestionDestinationSummary> ingestionDestinations) {
            this.ingestionDestinations = IngestionDestinationListCopier.copy(ingestionDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestionDestinations(IngestionDestinationSummary ... ingestionDestinations) {
            this.ingestionDestinations(Arrays.asList(ingestionDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestionDestinations(Consumer<IngestionDestinationSummary.Builder> ... ingestionDestinations) {
            this.ingestionDestinations(Stream.of(ingestionDestinations).map(c -> (IngestionDestinationSummary)((IngestionDestinationSummary.Builder)IngestionDestinationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIngestionDestinationsResponse build() {
            return new ListIngestionDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIngestionDestinationsResponse> {
        public Builder ingestionDestinations(Collection<IngestionDestinationSummary> var1);

        public Builder ingestionDestinations(IngestionDestinationSummary ... var1);

        public Builder ingestionDestinations(Consumer<IngestionDestinationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

