/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appfabric.AppFabricClient;
import software.amazon.awssdk.services.appfabric.model.AppBundleSummary;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse;

public class ListAppBundlesIterable
implements SdkIterable<ListAppBundlesResponse> {
    private final AppFabricClient client;
    private final ListAppBundlesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppBundlesIterable(AppFabricClient client, ListAppBundlesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppBundlesResponseFetcher();
    }

    public Iterator<ListAppBundlesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AppBundleSummary> appBundleSummaryList() {
        Function<ListAppBundlesResponse, Iterator> getIterator = response -> {
            if (response != null && response.appBundleSummaryList() != null) {
                return response.appBundleSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAppBundlesResponseFetcher
    implements SyncPageFetcher<ListAppBundlesResponse> {
        private ListAppBundlesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppBundlesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppBundlesResponse nextPage(ListAppBundlesResponse previousPage) {
            if (previousPage == null) {
                return ListAppBundlesIterable.this.client.listAppBundles(ListAppBundlesIterable.this.firstRequest);
            }
            return ListAppBundlesIterable.this.client.listAppBundles((ListAppBundlesRequest)((Object)ListAppBundlesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

