/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A value such as an Amazon Resource Name (ARN) or an Amazon Simple Notification Service topic entered in an extension
 * when invoked. Parameter values are specified in an extension association. For more information about extensions, see
 * <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending
 * workflows</a> in the <i>AppConfig User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameter implements SdkPojo, Serializable, ToCopyableBuilder<Parameter.Builder, Parameter> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Parameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Required").getter(getter(Parameter::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()).build();

    private static final SdkField<Boolean> DYNAMIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Dynamic").getter(getter(Parameter::dynamic)).setter(setter(Builder::dynamic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynamic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            REQUIRED_FIELD, DYNAMIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Boolean required;

    private final Boolean dynamic;

    private Parameter(BuilderImpl builder) {
        this.description = builder.description;
        this.required = builder.required;
        this.dynamic = builder.dynamic;
    }

    /**
     * <p>
     * Information about the parameter.
     * </p>
     * 
     * @return Information about the parameter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A parameter value must be specified in the extension association.
     * </p>
     * 
     * @return A parameter value must be specified in the extension association.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * Indicates whether this parameter's value can be supplied at the extension's action point instead of during
     * extension association. Dynamic parameters can't be marked <code>Required</code>.
     * </p>
     * 
     * @return Indicates whether this parameter's value can be supplied at the extension's action point instead of
     *         during extension association. Dynamic parameters can't be marked <code>Required</code>.
     */
    public final Boolean dynamic() {
        return dynamic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(dynamic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(required(), other.required())
                && Objects.equals(dynamic(), other.dynamic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameter").add("Description", description()).add("Required", required())
                .add("Dynamic", dynamic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Required":
            return Optional.ofNullable(clazz.cast(required()));
        case "Dynamic":
            return Optional.ofNullable(clazz.cast(dynamic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Required", REQUIRED_FIELD);
        map.put("Dynamic", DYNAMIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameter> {
        /**
         * <p>
         * Information about the parameter.
         * </p>
         * 
         * @param description
         *        Information about the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A parameter value must be specified in the extension association.
         * </p>
         * 
         * @param required
         *        A parameter value must be specified in the extension association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * Indicates whether this parameter's value can be supplied at the extension's action point instead of during
         * extension association. Dynamic parameters can't be marked <code>Required</code>.
         * </p>
         * 
         * @param dynamic
         *        Indicates whether this parameter's value can be supplied at the extension's action point instead of
         *        during extension association. Dynamic parameters can't be marked <code>Required</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamic(Boolean dynamic);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Boolean required;

        private Boolean dynamic;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            description(model.description);
            required(model.required);
            dynamic(model.dynamic);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final Boolean getDynamic() {
            return dynamic;
        }

        public final void setDynamic(Boolean dynamic) {
            this.dynamic = dynamic;
        }

        @Override
        public final Builder dynamic(Boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        @Override
        public Parameter build() {
            return new Parameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
