/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentResponse;
import software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.appconfig.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.appconfig.waiters.AppConfigAsyncWaiter;
import software.amazon.awssdk.services.appconfig.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultAppConfigAsyncWaiter
implements AppConfigAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final AppConfigAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetEnvironmentResponse> environmentReadyForDeploymentWaiter;
    private final AsyncWaiter<GetDeploymentResponse> deploymentCompleteWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultAppConfigAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AppConfigAsyncClient)AppConfigAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.environmentReadyForDeploymentWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetEnvironmentResponse.class).acceptors(DefaultAppConfigAsyncWaiter.environmentReadyForDeploymentWaiterAcceptors())).overrideConfiguration(DefaultAppConfigAsyncWaiter.environmentReadyForDeploymentWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.deploymentCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetDeploymentResponse.class).acceptors(DefaultAppConfigAsyncWaiter.deploymentCompleteWaiterAcceptors())).overrideConfiguration(DefaultAppConfigAsyncWaiter.deploymentCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentComplete(GetDeploymentRequest getDeploymentRequest) {
        return this.deploymentCompleteWaiter.runAsync(() -> this.client.getDeployment(this.applyWaitersUserAgent(getDeploymentRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentComplete(GetDeploymentRequest getDeploymentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.deploymentCompleteWaiter.runAsync(() -> this.client.getDeployment(this.applyWaitersUserAgent(getDeploymentRequest)), DefaultAppConfigAsyncWaiter.deploymentCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentReadyForDeployment(GetEnvironmentRequest getEnvironmentRequest) {
        return this.environmentReadyForDeploymentWaiter.runAsync(() -> this.client.getEnvironment(this.applyWaitersUserAgent(getEnvironmentRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentReadyForDeployment(GetEnvironmentRequest getEnvironmentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentReadyForDeploymentWaiter.runAsync(() -> this.client.getEnvironment(this.applyWaitersUserAgent(getEnvironmentRequest)), DefaultAppConfigAsyncWaiter.environmentReadyForDeploymentWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetEnvironmentResponse>> environmentReadyForDeploymentWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetEnvironmentResponse>> result = new ArrayList<WaiterAcceptor<? super GetEnvironmentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ReadyForDeployment");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "RolledBack");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=RolledBack) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Reverted");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=Reverted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetDeploymentResponse>> deploymentCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetDeploymentResponse>> result = new ArrayList<WaiterAcceptor<? super GetDeploymentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ROLLED_BACK");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=ROLLED_BACK) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "REVERTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=REVERTED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration environmentReadyForDeploymentWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration deploymentCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AppConfigAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AppConfigRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AppConfigRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AppConfigAsyncWaiter.Builder {
        private AppConfigAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public AppConfigAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public AppConfigAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AppConfigAsyncWaiter.Builder client(AppConfigAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AppConfigAsyncWaiter build() {
            return new DefaultAppConfigAsyncWaiter(this);
        }
    }
}

