/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.appconfig.model.HostedConfigurationVersionSummary;
import software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest;
import software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse;

public class ListHostedConfigurationVersionsIterable
implements SdkIterable<ListHostedConfigurationVersionsResponse> {
    private final AppConfigClient client;
    private final ListHostedConfigurationVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHostedConfigurationVersionsIterable(AppConfigClient client, ListHostedConfigurationVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHostedConfigurationVersionsResponseFetcher();
    }

    public Iterator<ListHostedConfigurationVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HostedConfigurationVersionSummary> items() {
        Function<ListHostedConfigurationVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHostedConfigurationVersionsResponseFetcher
    implements SyncPageFetcher<ListHostedConfigurationVersionsResponse> {
        private ListHostedConfigurationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListHostedConfigurationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHostedConfigurationVersionsResponse nextPage(ListHostedConfigurationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListHostedConfigurationVersionsIterable.this.client.listHostedConfigurationVersions(ListHostedConfigurationVersionsIterable.this.firstRequest);
            }
            return ListHostedConfigurationVersionsIterable.this.client.listHostedConfigurationVersions((ListHostedConfigurationVersionsRequest)((Object)ListHostedConfigurationVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

