/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostedConfigurationVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostedConfigurationVersionSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(HostedConfigurationVersionSummary.getter(HostedConfigurationVersionSummary::applicationId)).setter(HostedConfigurationVersionSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationProfileId").getter(HostedConfigurationVersionSummary.getter(HostedConfigurationVersionSummary::configurationProfileId)).setter(HostedConfigurationVersionSummary.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build()}).build();
    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VersionNumber").getter(HostedConfigurationVersionSummary.getter(HostedConfigurationVersionSummary::versionNumber)).setter(HostedConfigurationVersionSummary.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(HostedConfigurationVersionSummary.getter(HostedConfigurationVersionSummary::description)).setter(HostedConfigurationVersionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(HostedConfigurationVersionSummary.getter(HostedConfigurationVersionSummary::contentType)).setter(HostedConfigurationVersionSummary.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(HostedConfigurationVersionSummary.getter(HostedConfigurationVersionSummary::versionLabel)).setter(HostedConfigurationVersionSummary.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(HostedConfigurationVersionSummary.getter(HostedConfigurationVersionSummary::kmsKeyArn)).setter(HostedConfigurationVersionSummary.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, VERSION_NUMBER_FIELD, DESCRIPTION_FIELD, CONTENT_TYPE_FIELD, VERSION_LABEL_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HostedConfigurationVersionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String configurationProfileId;
    private final Integer versionNumber;
    private final String description;
    private final String contentType;
    private final String versionLabel;
    private final String kmsKeyArn;

    private HostedConfigurationVersionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.versionNumber = builder.versionNumber;
        this.description = builder.description;
        this.contentType = builder.contentType;
        this.versionLabel = builder.versionLabel;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String configurationProfileId() {
        return this.configurationProfileId;
    }

    public final Integer versionNumber() {
        return this.versionNumber;
    }

    public final String description() {
        return this.description;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedConfigurationVersionSummary)) {
            return false;
        }
        HostedConfigurationVersionSummary other = (HostedConfigurationVersionSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"HostedConfigurationVersionSummary").add("ApplicationId", (Object)this.applicationId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("VersionNumber", (Object)this.versionNumber()).add("Description", (Object)this.description()).add("ContentType", (Object)this.contentType()).add("VersionLabel", (Object)this.versionLabel()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ConfigurationProfileId", CONFIGURATION_PROFILE_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("VersionLabel", VERSION_LABEL_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostedConfigurationVersionSummary, T> g) {
        return obj -> g.apply((HostedConfigurationVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String configurationProfileId;
        private Integer versionNumber;
        private String description;
        private String contentType;
        private String versionLabel;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedConfigurationVersionSummary model) {
            this.applicationId(model.applicationId);
            this.configurationProfileId(model.configurationProfileId);
            this.versionNumber(model.versionNumber);
            this.description(model.description);
            this.contentType(model.contentType);
            this.versionLabel(model.versionLabel);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final Integer getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public HostedConfigurationVersionSummary build() {
            return new HostedConfigurationVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostedConfigurationVersionSummary> {
        public Builder applicationId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder versionNumber(Integer var1);

        public Builder description(String var1);

        public Builder contentType(String var1);

        public Builder versionLabel(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

