/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.DeletionProtectionCheck;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteEnvironmentRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, DeleteEnvironmentRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(DeleteEnvironmentRequest.getter(DeleteEnvironmentRequest::environmentId)).setter(DeleteEnvironmentRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(DeleteEnvironmentRequest.getter(DeleteEnvironmentRequest::applicationId)).setter(DeleteEnvironmentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> DELETION_PROTECTION_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionProtectionCheck").getter(DeleteEnvironmentRequest.getter(DeleteEnvironmentRequest::deletionProtectionCheckAsString)).setter(DeleteEnvironmentRequest.setter(Builder::deletionProtectionCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-deletion-protection-check").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, APPLICATION_ID_FIELD, DELETION_PROTECTION_CHECK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
            this.put("ApplicationId", APPLICATION_ID_FIELD);
            this.put("x-amzn-deletion-protection-check", DELETION_PROTECTION_CHECK_FIELD);
        }
    });
    private final String environmentId;
    private final String applicationId;
    private final String deletionProtectionCheck;

    private DeleteEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.applicationId = builder.applicationId;
        this.deletionProtectionCheck = builder.deletionProtectionCheck;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final DeletionProtectionCheck deletionProtectionCheck() {
        return DeletionProtectionCheck.fromValue(this.deletionProtectionCheck);
    }

    public final String deletionProtectionCheckAsString() {
        return this.deletionProtectionCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionCheckAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEnvironmentRequest)) {
            return false;
        }
        DeleteEnvironmentRequest other = (DeleteEnvironmentRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.deletionProtectionCheckAsString(), other.deletionProtectionCheckAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteEnvironmentRequest").add("EnvironmentId", (Object)this.environmentId()).add("ApplicationId", (Object)this.applicationId()).add("DeletionProtectionCheck", (Object)this.deletionProtectionCheckAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "DeletionProtectionCheck": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionCheckAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEnvironmentRequest, T> g) {
        return obj -> g.apply((DeleteEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String applicationId;
        private String deletionProtectionCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEnvironmentRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.applicationId(model.applicationId);
            this.deletionProtectionCheck(model.deletionProtectionCheck);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDeletionProtectionCheck() {
            return this.deletionProtectionCheck;
        }

        public final void setDeletionProtectionCheck(String deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
        }

        @Override
        public final Builder deletionProtectionCheck(String deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
            return this;
        }

        @Override
        public final Builder deletionProtectionCheck(DeletionProtectionCheck deletionProtectionCheck) {
            this.deletionProtectionCheck(deletionProtectionCheck == null ? null : deletionProtectionCheck.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEnvironmentRequest build() {
            return new DeleteEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteEnvironmentRequest> {
        public Builder environmentId(String var1);

        public Builder applicationId(String var1);

        public Builder deletionProtectionCheck(String var1);

        public Builder deletionProtectionCheck(DeletionProtectionCheck var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

