/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GrowthType {
    LINEAR("LINEAR"),
    EXPONENTIAL("EXPONENTIAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GrowthType> VALUE_MAP;
    private final String value;

    private GrowthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GrowthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GrowthType> knownValues() {
        EnumSet<GrowthType> knownValues = EnumSet.allOf(GrowthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GrowthType.class, GrowthType::toString);
    }
}

