/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClientBuilder;
import software.amazon.awssdk.services.appconfig.AppConfigServiceClientConfiguration;
import software.amazon.awssdk.services.appconfig.DefaultAppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.DefaultAppConfigBaseClientBuilder;
import software.amazon.awssdk.services.appconfig.endpoints.AppConfigEndpointProvider;

@SdkInternalApi
final class DefaultAppConfigAsyncClientBuilder
extends DefaultAppConfigBaseClientBuilder<AppConfigAsyncClientBuilder, AppConfigAsyncClient>
implements AppConfigAsyncClientBuilder {
    DefaultAppConfigAsyncClientBuilder() {
    }

    @Override
    public DefaultAppConfigAsyncClientBuilder endpointProvider(AppConfigEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppConfigAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAppConfigAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AppConfigServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppConfigAsyncClient client = new DefaultAppConfigAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppConfigServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppConfigServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

