/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.TagMapCopier;
import software.amazon.awssdk.services.appconfig.model.Validator;
import software.amazon.awssdk.services.appconfig.model.ValidatorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationProfileRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, CreateConfigurationProfileRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateConfigurationProfileRequest.getter(CreateConfigurationProfileRequest::applicationId)).setter(CreateConfigurationProfileRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConfigurationProfileRequest.getter(CreateConfigurationProfileRequest::name)).setter(CreateConfigurationProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateConfigurationProfileRequest.getter(CreateConfigurationProfileRequest::description)).setter(CreateConfigurationProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(CreateConfigurationProfileRequest.getter(CreateConfigurationProfileRequest::locationUri)).setter(CreateConfigurationProfileRequest.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalRoleArn").getter(CreateConfigurationProfileRequest.getter(CreateConfigurationProfileRequest::retrievalRoleArn)).setter(CreateConfigurationProfileRequest.setter(Builder::retrievalRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()}).build();
    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Validators").getter(CreateConfigurationProfileRequest.getter(CreateConfigurationProfileRequest::validators)).setter(CreateConfigurationProfileRequest.setter(Builder::validators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Validator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateConfigurationProfileRequest.getter(CreateConfigurationProfileRequest::tags)).setter(CreateConfigurationProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOCATION_URI_FIELD, RETRIEVAL_ROLE_ARN_FIELD, VALIDATORS_FIELD, TAGS_FIELD));
    private final String applicationId;
    private final String name;
    private final String description;
    private final String locationUri;
    private final String retrievalRoleArn;
    private final List<Validator> validators;
    private final Map<String, String> tags;

    private CreateConfigurationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
        this.tags = builder.tags;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final String retrievalRoleArn() {
        return this.retrievalRoleArn;
    }

    public final boolean hasValidators() {
        return this.validators != null && !(this.validators instanceof SdkAutoConstructList);
    }

    public final List<Validator> validators() {
        return this.validators;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidators() ? this.validators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationProfileRequest)) {
            return false;
        }
        CreateConfigurationProfileRequest other = (CreateConfigurationProfileRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.locationUri(), other.locationUri()) && Objects.equals(this.retrievalRoleArn(), other.retrievalRoleArn()) && this.hasValidators() == other.hasValidators() && Objects.equals(this.validators(), other.validators()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfigurationProfileRequest").add("ApplicationId", (Object)this.applicationId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LocationUri", (Object)this.locationUri()).add("RetrievalRoleArn", (Object)this.retrievalRoleArn()).add("Validators", this.hasValidators() ? this.validators() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "RetrievalRoleArn": {
                return Optional.ofNullable(clazz.cast(this.retrievalRoleArn()));
            }
            case "Validators": {
                return Optional.ofNullable(clazz.cast(this.validators()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationProfileRequest, T> g) {
        return obj -> g.apply((CreateConfigurationProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String name;
        private String description;
        private String locationUri;
        private String retrievalRoleArn;
        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationProfileRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.name(model.name);
            this.description(model.description);
            this.locationUri(model.locationUri);
            this.retrievalRoleArn(model.retrievalRoleArn);
            this.validators(model.validators);
            this.tags(model.tags);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final String getRetrievalRoleArn() {
            return this.retrievalRoleArn;
        }

        @Override
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        public final Collection<Validator.Builder> getValidators() {
            if (this.validators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validators != null ? (Collection)this.validators.stream().map(Validator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator ... validators) {
            this.validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder> ... validators) {
            this.validators(Stream.of(validators).map(c -> (Validator)((Validator.Builder)Validator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationProfileRequest build() {
            return new CreateConfigurationProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationProfileRequest> {
        public Builder applicationId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder locationUri(String var1);

        public Builder retrievalRoleArn(String var1);

        public Builder validators(Collection<Validator> var1);

        public Builder validators(Validator ... var1);

        public Builder validators(Consumer<Validator.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

