/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum GrowthType {
    LINEAR("LINEAR"),
    EXPONENTIAL("EXPONENTIAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private GrowthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GrowthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(GrowthType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GrowthType> knownValues() {
        return Stream.of(GrowthType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

