/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHostedConfigurationVersionResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, CreateHostedConfigurationVersionResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedConfigurationVersionResponse.getter(CreateHostedConfigurationVersionResponse::applicationId)).setter(CreateHostedConfigurationVersionResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Application-Id").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedConfigurationVersionResponse.getter(CreateHostedConfigurationVersionResponse::configurationProfileId)).setter(CreateHostedConfigurationVersionResponse.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Configuration-Profile-Id").build()}).build();
    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateHostedConfigurationVersionResponse.getter(CreateHostedConfigurationVersionResponse::versionNumber)).setter(CreateHostedConfigurationVersionResponse.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Version-Number").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedConfigurationVersionResponse.getter(CreateHostedConfigurationVersionResponse::description)).setter(CreateHostedConfigurationVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Description").build()}).build();
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(CreateHostedConfigurationVersionResponse.getter(CreateHostedConfigurationVersionResponse::content)).setter(CreateHostedConfigurationVersionResponse.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedConfigurationVersionResponse.getter(CreateHostedConfigurationVersionResponse::contentType)).setter(CreateHostedConfigurationVersionResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, VERSION_NUMBER_FIELD, DESCRIPTION_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD));
    private final String applicationId;
    private final String configurationProfileId;
    private final Integer versionNumber;
    private final String description;
    private final SdkBytes content;
    private final String contentType;

    private CreateHostedConfigurationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.versionNumber = builder.versionNumber;
        this.description = builder.description;
        this.content = builder.content;
        this.contentType = builder.contentType;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String configurationProfileId() {
        return this.configurationProfileId;
    }

    public Integer versionNumber() {
        return this.versionNumber;
    }

    public String description() {
        return this.description;
    }

    public SdkBytes content() {
        return this.content;
    }

    public String contentType() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedConfigurationVersionResponse)) {
            return false;
        }
        CreateHostedConfigurationVersionResponse other = (CreateHostedConfigurationVersionResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.contentType(), other.contentType());
    }

    public String toString() {
        return ToString.builder((String)"CreateHostedConfigurationVersionResponse").add("ApplicationId", (Object)this.applicationId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("VersionNumber", (Object)this.versionNumber()).add("Description", (Object)this.description()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHostedConfigurationVersionResponse, T> g) {
        return obj -> g.apply((CreateHostedConfigurationVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String configurationProfileId;
        private Integer versionNumber;
        private String description;
        private SdkBytes content;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedConfigurationVersionResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.configurationProfileId(model.configurationProfileId);
            this.versionNumber(model.versionNumber);
            this.description(model.description);
            this.content(model.content);
            this.contentType(model.contentType);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        public final Integer getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ByteBuffer getContent() {
            return this.content == null ? null : this.content.asByteBuffer();
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = StandardMemberCopier.copy((SdkBytes)content);
            return this;
        }

        public final void setContent(ByteBuffer content) {
            this.content(content == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)content));
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public CreateHostedConfigurationVersionResponse build() {
            return new CreateHostedConfigurationVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHostedConfigurationVersionResponse> {
        public Builder applicationId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder versionNumber(Integer var1);

        public Builder description(String var1);

        public Builder content(SdkBytes var1);

        public Builder contentType(String var1);
    }
}

