/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.services.appconfig.model.Validator;
import software.amazon.awssdk.services.appconfig.model.ValidatorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationProfileResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, GetConfigurationProfileResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigurationProfileResponse.getter(GetConfigurationProfileResponse::applicationId)).setter(GetConfigurationProfileResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigurationProfileResponse.getter(GetConfigurationProfileResponse::id)).setter(GetConfigurationProfileResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigurationProfileResponse.getter(GetConfigurationProfileResponse::name)).setter(GetConfigurationProfileResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigurationProfileResponse.getter(GetConfigurationProfileResponse::description)).setter(GetConfigurationProfileResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigurationProfileResponse.getter(GetConfigurationProfileResponse::locationUri)).setter(GetConfigurationProfileResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConfigurationProfileResponse.getter(GetConfigurationProfileResponse::retrievalRoleArn)).setter(GetConfigurationProfileResponse.setter(Builder::retrievalRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()}).build();
    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetConfigurationProfileResponse.getter(GetConfigurationProfileResponse::validators)).setter(GetConfigurationProfileResponse.setter(Builder::validators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Validator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOCATION_URI_FIELD, RETRIEVAL_ROLE_ARN_FIELD, VALIDATORS_FIELD));
    private final String applicationId;
    private final String id;
    private final String name;
    private final String description;
    private final String locationUri;
    private final String retrievalRoleArn;
    private final List<Validator> validators;

    private GetConfigurationProfileResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String locationUri() {
        return this.locationUri;
    }

    public String retrievalRoleArn() {
        return this.retrievalRoleArn;
    }

    public List<Validator> validators() {
        return this.validators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.validators());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationProfileResponse)) {
            return false;
        }
        GetConfigurationProfileResponse other = (GetConfigurationProfileResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.locationUri(), other.locationUri()) && Objects.equals(this.retrievalRoleArn(), other.retrievalRoleArn()) && Objects.equals(this.validators(), other.validators());
    }

    public String toString() {
        return ToString.builder((String)"GetConfigurationProfileResponse").add("ApplicationId", (Object)this.applicationId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LocationUri", (Object)this.locationUri()).add("RetrievalRoleArn", (Object)this.retrievalRoleArn()).add("Validators", this.validators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "RetrievalRoleArn": {
                return Optional.ofNullable(clazz.cast(this.retrievalRoleArn()));
            }
            case "Validators": {
                return Optional.ofNullable(clazz.cast(this.validators()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationProfileResponse, T> g) {
        return obj -> g.apply((GetConfigurationProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String id;
        private String name;
        private String description;
        private String locationUri;
        private String retrievalRoleArn;
        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationProfileResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.locationUri(model.locationUri);
            this.retrievalRoleArn(model.retrievalRoleArn);
            this.validators(model.validators);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final String getRetrievalRoleArn() {
            return this.retrievalRoleArn;
        }

        @Override
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        public final Collection<Validator.Builder> getValidators() {
            return this.validators != null ? (Collection)this.validators.stream().map(Validator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator ... validators) {
            this.validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder> ... validators) {
            this.validators(Stream.of(validators).map(c -> (Validator)((Validator.Builder)Validator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        @Override
        public GetConfigurationProfileResponse build() {
            return new GetConfigurationProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationProfileResponse> {
        public Builder applicationId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder locationUri(String var1);

        public Builder retrievalRoleArn(String var1);

        public Builder validators(Collection<Validator> var1);

        public Builder validators(Validator ... var1);

        public Builder validators(Consumer<Validator.Builder> ... var1);
    }
}

