/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigatewayv2.model.IntegrationParametersCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TemplateMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIntegrationResponseResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, UpdateIntegrationResponseResponse> {
    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::contentHandlingStrategyAsString)).setter(UpdateIntegrationResponseResponse.setter(Builder::contentHandlingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build()}).build();
    private static final SdkField<String> INTEGRATION_RESPONSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::integrationResponseId)).setter(UpdateIntegrationResponseResponse.setter(Builder::integrationResponseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseId").build()}).build();
    private static final SdkField<String> INTEGRATION_RESPONSE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::integrationResponseKey)).setter(UpdateIntegrationResponseResponse.setter(Builder::integrationResponseKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseKey").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::responseParameters)).setter(UpdateIntegrationResponseResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::responseTemplates)).setter(UpdateIntegrationResponseResponse.setter(Builder::responseTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIntegrationResponseResponse.getter(UpdateIntegrationResponseResponse::templateSelectionExpression)).setter(UpdateIntegrationResponseResponse.setter(Builder::templateSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_HANDLING_STRATEGY_FIELD, INTEGRATION_RESPONSE_ID_FIELD, INTEGRATION_RESPONSE_KEY_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD));
    private final String contentHandlingStrategy;
    private final String integrationResponseId;
    private final String integrationResponseKey;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;
    private final String templateSelectionExpression;

    private UpdateIntegrationResponseResponse(BuilderImpl builder) {
        super(builder);
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.integrationResponseId = builder.integrationResponseId;
        this.integrationResponseKey = builder.integrationResponseKey;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.templateSelectionExpression = builder.templateSelectionExpression;
    }

    public ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(this.contentHandlingStrategy);
    }

    public String contentHandlingStrategyAsString() {
        return this.contentHandlingStrategy;
    }

    public String integrationResponseId() {
        return this.integrationResponseId;
    }

    public String integrationResponseKey() {
        return this.integrationResponseKey;
    }

    public Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    public String templateSelectionExpression() {
        return this.templateSelectionExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationResponseKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateSelectionExpression());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationResponseResponse)) {
            return false;
        }
        UpdateIntegrationResponseResponse other = (UpdateIntegrationResponseResponse)((Object)obj);
        return Objects.equals(this.contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString()) && Objects.equals(this.integrationResponseId(), other.integrationResponseId()) && Objects.equals(this.integrationResponseKey(), other.integrationResponseKey()) && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.responseTemplates(), other.responseTemplates()) && Objects.equals(this.templateSelectionExpression(), other.templateSelectionExpression());
    }

    public String toString() {
        return ToString.builder((String)"UpdateIntegrationResponseResponse").add("ContentHandlingStrategy", (Object)this.contentHandlingStrategyAsString()).add("IntegrationResponseId", (Object)this.integrationResponseId()).add("IntegrationResponseKey", (Object)this.integrationResponseKey()).add("ResponseParameters", this.responseParameters()).add("ResponseTemplates", this.responseTemplates()).add("TemplateSelectionExpression", (Object)this.templateSelectionExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentHandlingStrategy": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingStrategyAsString()));
            }
            case "IntegrationResponseId": {
                return Optional.ofNullable(clazz.cast(this.integrationResponseId()));
            }
            case "IntegrationResponseKey": {
                return Optional.ofNullable(clazz.cast(this.integrationResponseKey()));
            }
            case "ResponseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "ResponseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
            case "TemplateSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.templateSelectionExpression()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationResponseResponse, T> g) {
        return obj -> g.apply((UpdateIntegrationResponseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private String contentHandlingStrategy;
        private String integrationResponseId;
        private String integrationResponseKey;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String templateSelectionExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationResponseResponse model) {
            super(model);
            this.contentHandlingStrategy(model.contentHandlingStrategy);
            this.integrationResponseId(model.integrationResponseId);
            this.integrationResponseKey(model.integrationResponseKey);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
            this.templateSelectionExpression(model.templateSelectionExpression);
        }

        public final String getContentHandlingStrategyAsString() {
            return this.contentHandlingStrategy;
        }

        @Override
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy.toString());
            return this;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        public final String getIntegrationResponseId() {
            return this.integrationResponseId;
        }

        @Override
        public final Builder integrationResponseId(String integrationResponseId) {
            this.integrationResponseId = integrationResponseId;
            return this;
        }

        public final void setIntegrationResponseId(String integrationResponseId) {
            this.integrationResponseId = integrationResponseId;
        }

        public final String getIntegrationResponseKey() {
            return this.integrationResponseKey;
        }

        @Override
        public final Builder integrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
            return this;
        }

        public final void setIntegrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
        }

        public final Map<String, String> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            return this.responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
        }

        public final String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        @Override
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        @Override
        public UpdateIntegrationResponseResponse build() {
            return new UpdateIntegrationResponseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIntegrationResponseResponse> {
        public Builder contentHandlingStrategy(String var1);

        public Builder contentHandlingStrategy(ContentHandlingStrategy var1);

        public Builder integrationResponseId(String var1);

        public Builder integrationResponseKey(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder templateSelectionExpression(String var1);
    }
}

