/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRouteResponseRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, DeleteRouteResponseRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRouteResponseRequest.getter(DeleteRouteResponseRequest::apiId)).setter(DeleteRouteResponseRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRouteResponseRequest.getter(DeleteRouteResponseRequest::routeId)).setter(DeleteRouteResponseRequest.setter(Builder::routeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeId").build()}).build();
    private static final SdkField<String> ROUTE_RESPONSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRouteResponseRequest.getter(DeleteRouteResponseRequest::routeResponseId)).setter(DeleteRouteResponseRequest.setter(Builder::routeResponseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeResponseId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, ROUTE_ID_FIELD, ROUTE_RESPONSE_ID_FIELD));
    private final String apiId;
    private final String routeId;
    private final String routeResponseId;

    private DeleteRouteResponseRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.routeId = builder.routeId;
        this.routeResponseId = builder.routeResponseId;
    }

    public String apiId() {
        return this.apiId;
    }

    public String routeId() {
        return this.routeId;
    }

    public String routeResponseId() {
        return this.routeResponseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeResponseId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteResponseRequest)) {
            return false;
        }
        DeleteRouteResponseRequest other = (DeleteRouteResponseRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.routeId(), other.routeId()) && Objects.equals(this.routeResponseId(), other.routeResponseId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteRouteResponseRequest").add("ApiId", (Object)this.apiId()).add("RouteId", (Object)this.routeId()).add("RouteResponseId", (Object)this.routeResponseId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "RouteId": {
                return Optional.ofNullable(clazz.cast(this.routeId()));
            }
            case "RouteResponseId": {
                return Optional.ofNullable(clazz.cast(this.routeResponseId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteResponseRequest, T> g) {
        return obj -> g.apply((DeleteRouteResponseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String routeId;
        private String routeResponseId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteResponseRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.routeId(model.routeId);
            this.routeResponseId(model.routeResponseId);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getRouteId() {
            return this.routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public final String getRouteResponseId() {
            return this.routeResponseId;
        }

        @Override
        public final Builder routeResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
            return this;
        }

        public final void setRouteResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteResponseRequest build() {
            return new DeleteRouteResponseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRouteResponseRequest> {
        public Builder apiId(String var1);

        public Builder routeId(String var1);

        public Builder routeResponseId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

