/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2Client;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductRestEndpointPagesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductRestEndpointPagesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ProductRestEndpointPageSummaryNoBody;

public class ListProductRestEndpointPagesIterable
implements SdkIterable<ListProductRestEndpointPagesResponse> {
    private final ApiGatewayV2Client client;
    private final ListProductRestEndpointPagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProductRestEndpointPagesIterable(ApiGatewayV2Client client, ListProductRestEndpointPagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProductRestEndpointPagesResponseFetcher();
    }

    public Iterator<ListProductRestEndpointPagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProductRestEndpointPageSummaryNoBody> items() {
        Function<ListProductRestEndpointPagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProductRestEndpointPagesResponseFetcher
    implements SyncPageFetcher<ListProductRestEndpointPagesResponse> {
        private ListProductRestEndpointPagesResponseFetcher() {
        }

        public boolean hasNextPage(ListProductRestEndpointPagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProductRestEndpointPagesResponse nextPage(ListProductRestEndpointPagesResponse previousPage) {
            if (previousPage == null) {
                return ListProductRestEndpointPagesIterable.this.client.listProductRestEndpointPages(ListProductRestEndpointPagesIterable.this.firstRequest);
            }
            return ListProductRestEndpointPagesIterable.this.client.listProductRestEndpointPages((ListProductRestEndpointPagesRequest)((Object)ListProductRestEndpointPagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

