/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.DisplayOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePortalProductRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, UpdatePortalProductRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePortalProductRequest.getter(UpdatePortalProductRequest::description)).setter(UpdatePortalProductRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdatePortalProductRequest.getter(UpdatePortalProductRequest::displayName)).setter(UpdatePortalProductRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<DisplayOrder> DISPLAY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayOrder").getter(UpdatePortalProductRequest.getter(UpdatePortalProductRequest::displayOrder)).setter(UpdatePortalProductRequest.setter(Builder::displayOrder)).constructor(DisplayOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayOrder").build()}).build();
    private static final SdkField<String> PORTAL_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalProductId").getter(UpdatePortalProductRequest.getter(UpdatePortalProductRequest::portalProductId)).setter(UpdatePortalProductRequest.setter(Builder::portalProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalProductId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, DISPLAY_ORDER_FIELD, PORTAL_PRODUCT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePortalProductRequest.memberNameToFieldInitializer();
    private final String description;
    private final String displayName;
    private final DisplayOrder displayOrder;
    private final String portalProductId;

    private UpdatePortalProductRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.displayOrder = builder.displayOrder;
        this.portalProductId = builder.portalProductId;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final DisplayOrder displayOrder() {
        return this.displayOrder;
    }

    public final String portalProductId() {
        return this.portalProductId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalProductId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortalProductRequest)) {
            return false;
        }
        UpdatePortalProductRequest other = (UpdatePortalProductRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.displayOrder(), other.displayOrder()) && Objects.equals(this.portalProductId(), other.portalProductId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePortalProductRequest").add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("DisplayOrder", (Object)this.displayOrder()).add("PortalProductId", (Object)this.portalProductId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "DisplayOrder": {
                return Optional.ofNullable(clazz.cast(this.displayOrder()));
            }
            case "PortalProductId": {
                return Optional.ofNullable(clazz.cast(this.portalProductId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("displayOrder", DISPLAY_ORDER_FIELD);
        map.put("portalProductId", PORTAL_PRODUCT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortalProductRequest, T> g) {
        return obj -> g.apply((UpdatePortalProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String description;
        private String displayName;
        private DisplayOrder displayOrder;
        private String portalProductId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortalProductRequest model) {
            super(model);
            this.description(model.description);
            this.displayName(model.displayName);
            this.displayOrder(model.displayOrder);
            this.portalProductId(model.portalProductId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final DisplayOrder.Builder getDisplayOrder() {
            return this.displayOrder != null ? this.displayOrder.toBuilder() : null;
        }

        public final void setDisplayOrder(DisplayOrder.BuilderImpl displayOrder) {
            this.displayOrder = displayOrder != null ? displayOrder.build() : null;
        }

        @Override
        public final Builder displayOrder(DisplayOrder displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final String getPortalProductId() {
            return this.portalProductId;
        }

        public final void setPortalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
        }

        @Override
        public final Builder portalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePortalProductRequest build() {
            return new UpdatePortalProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePortalProductRequest> {
        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder displayOrder(DisplayOrder var1);

        default public Builder displayOrder(Consumer<DisplayOrder.Builder> displayOrder) {
            return this.displayOrder((DisplayOrder)((DisplayOrder.Builder)DisplayOrder.builder().applyMutation(displayOrder)).build());
        }

        public Builder portalProductId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

