/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.RestEndpointIdentifier;
import software.amazon.awssdk.services.apigatewayv2.model.Status;
import software.amazon.awssdk.services.apigatewayv2.model.StatusException;
import software.amazon.awssdk.services.apigatewayv2.model.TryItState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductRestEndpointPageSummaryNoBody
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductRestEndpointPageSummaryNoBody> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::endpoint)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::lastModified)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::operationName)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()}).build();
    private static final SdkField<String> PRODUCT_REST_ENDPOINT_PAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductRestEndpointPageArn").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::productRestEndpointPageArn)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::productRestEndpointPageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productRestEndpointPageArn").build()}).build();
    private static final SdkField<String> PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductRestEndpointPageId").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::productRestEndpointPageId)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::productRestEndpointPageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productRestEndpointPageId").build()}).build();
    private static final SdkField<RestEndpointIdentifier> REST_ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestEndpointIdentifier").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::restEndpointIdentifier)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::restEndpointIdentifier)).constructor(RestEndpointIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restEndpointIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::statusAsString)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusException> STATUS_EXCEPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusException").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::statusException)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::statusException)).constructor(StatusException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusException").build()}).build();
    private static final SdkField<String> TRY_IT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TryItState").getter(ProductRestEndpointPageSummaryNoBody.getter(ProductRestEndpointPageSummaryNoBody::tryItStateAsString)).setter(ProductRestEndpointPageSummaryNoBody.setter(Builder::tryItState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tryItState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, LAST_MODIFIED_FIELD, OPERATION_NAME_FIELD, PRODUCT_REST_ENDPOINT_PAGE_ARN_FIELD, PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD, REST_ENDPOINT_IDENTIFIER_FIELD, STATUS_FIELD, STATUS_EXCEPTION_FIELD, TRY_IT_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductRestEndpointPageSummaryNoBody.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final Instant lastModified;
    private final String operationName;
    private final String productRestEndpointPageArn;
    private final String productRestEndpointPageId;
    private final RestEndpointIdentifier restEndpointIdentifier;
    private final String status;
    private final StatusException statusException;
    private final String tryItState;

    private ProductRestEndpointPageSummaryNoBody(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.lastModified = builder.lastModified;
        this.operationName = builder.operationName;
        this.productRestEndpointPageArn = builder.productRestEndpointPageArn;
        this.productRestEndpointPageId = builder.productRestEndpointPageId;
        this.restEndpointIdentifier = builder.restEndpointIdentifier;
        this.status = builder.status;
        this.statusException = builder.statusException;
        this.tryItState = builder.tryItState;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final String productRestEndpointPageArn() {
        return this.productRestEndpointPageArn;
    }

    public final String productRestEndpointPageId() {
        return this.productRestEndpointPageId;
    }

    public final RestEndpointIdentifier restEndpointIdentifier() {
        return this.restEndpointIdentifier;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusException statusException() {
        return this.statusException;
    }

    public final TryItState tryItState() {
        return TryItState.fromValue(this.tryItState);
    }

    public final String tryItStateAsString() {
        return this.tryItState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productRestEndpointPageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productRestEndpointPageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.restEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusException());
        hashCode = 31 * hashCode + Objects.hashCode(this.tryItStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductRestEndpointPageSummaryNoBody)) {
            return false;
        }
        ProductRestEndpointPageSummaryNoBody other = (ProductRestEndpointPageSummaryNoBody)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.productRestEndpointPageArn(), other.productRestEndpointPageArn()) && Objects.equals(this.productRestEndpointPageId(), other.productRestEndpointPageId()) && Objects.equals(this.restEndpointIdentifier(), other.restEndpointIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusException(), other.statusException()) && Objects.equals(this.tryItStateAsString(), other.tryItStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProductRestEndpointPageSummaryNoBody").add("Endpoint", (Object)this.endpoint()).add("LastModified", (Object)this.lastModified()).add("OperationName", (Object)this.operationName()).add("ProductRestEndpointPageArn", (Object)this.productRestEndpointPageArn()).add("ProductRestEndpointPageId", (Object)this.productRestEndpointPageId()).add("RestEndpointIdentifier", (Object)this.restEndpointIdentifier()).add("Status", (Object)this.statusAsString()).add("StatusException", (Object)this.statusException()).add("TryItState", (Object)this.tryItStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "ProductRestEndpointPageArn": {
                return Optional.ofNullable(clazz.cast(this.productRestEndpointPageArn()));
            }
            case "ProductRestEndpointPageId": {
                return Optional.ofNullable(clazz.cast(this.productRestEndpointPageId()));
            }
            case "RestEndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.restEndpointIdentifier()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusException": {
                return Optional.ofNullable(clazz.cast(this.statusException()));
            }
            case "TryItState": {
                return Optional.ofNullable(clazz.cast(this.tryItStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("operationName", OPERATION_NAME_FIELD);
        map.put("productRestEndpointPageArn", PRODUCT_REST_ENDPOINT_PAGE_ARN_FIELD);
        map.put("productRestEndpointPageId", PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD);
        map.put("restEndpointIdentifier", REST_ENDPOINT_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusException", STATUS_EXCEPTION_FIELD);
        map.put("tryItState", TRY_IT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductRestEndpointPageSummaryNoBody, T> g) {
        return obj -> g.apply((ProductRestEndpointPageSummaryNoBody)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private Instant lastModified;
        private String operationName;
        private String productRestEndpointPageArn;
        private String productRestEndpointPageId;
        private RestEndpointIdentifier restEndpointIdentifier;
        private String status;
        private StatusException statusException;
        private String tryItState;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductRestEndpointPageSummaryNoBody model) {
            this.endpoint(model.endpoint);
            this.lastModified(model.lastModified);
            this.operationName(model.operationName);
            this.productRestEndpointPageArn(model.productRestEndpointPageArn);
            this.productRestEndpointPageId(model.productRestEndpointPageId);
            this.restEndpointIdentifier(model.restEndpointIdentifier);
            this.status(model.status);
            this.statusException(model.statusException);
            this.tryItState(model.tryItState);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getProductRestEndpointPageArn() {
            return this.productRestEndpointPageArn;
        }

        public final void setProductRestEndpointPageArn(String productRestEndpointPageArn) {
            this.productRestEndpointPageArn = productRestEndpointPageArn;
        }

        @Override
        public final Builder productRestEndpointPageArn(String productRestEndpointPageArn) {
            this.productRestEndpointPageArn = productRestEndpointPageArn;
            return this;
        }

        public final String getProductRestEndpointPageId() {
            return this.productRestEndpointPageId;
        }

        public final void setProductRestEndpointPageId(String productRestEndpointPageId) {
            this.productRestEndpointPageId = productRestEndpointPageId;
        }

        @Override
        public final Builder productRestEndpointPageId(String productRestEndpointPageId) {
            this.productRestEndpointPageId = productRestEndpointPageId;
            return this;
        }

        public final RestEndpointIdentifier.Builder getRestEndpointIdentifier() {
            return this.restEndpointIdentifier != null ? this.restEndpointIdentifier.toBuilder() : null;
        }

        public final void setRestEndpointIdentifier(RestEndpointIdentifier.BuilderImpl restEndpointIdentifier) {
            this.restEndpointIdentifier = restEndpointIdentifier != null ? restEndpointIdentifier.build() : null;
        }

        @Override
        public final Builder restEndpointIdentifier(RestEndpointIdentifier restEndpointIdentifier) {
            this.restEndpointIdentifier = restEndpointIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusException.Builder getStatusException() {
            return this.statusException != null ? this.statusException.toBuilder() : null;
        }

        public final void setStatusException(StatusException.BuilderImpl statusException) {
            this.statusException = statusException != null ? statusException.build() : null;
        }

        @Override
        public final Builder statusException(StatusException statusException) {
            this.statusException = statusException;
            return this;
        }

        public final String getTryItState() {
            return this.tryItState;
        }

        public final void setTryItState(String tryItState) {
            this.tryItState = tryItState;
        }

        @Override
        public final Builder tryItState(String tryItState) {
            this.tryItState = tryItState;
            return this;
        }

        @Override
        public final Builder tryItState(TryItState tryItState) {
            this.tryItState(tryItState == null ? null : tryItState.toString());
            return this;
        }

        public ProductRestEndpointPageSummaryNoBody build() {
            return new ProductRestEndpointPageSummaryNoBody(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductRestEndpointPageSummaryNoBody> {
        public Builder endpoint(String var1);

        public Builder lastModified(Instant var1);

        public Builder operationName(String var1);

        public Builder productRestEndpointPageArn(String var1);

        public Builder productRestEndpointPageId(String var1);

        public Builder restEndpointIdentifier(RestEndpointIdentifier var1);

        default public Builder restEndpointIdentifier(Consumer<RestEndpointIdentifier.Builder> restEndpointIdentifier) {
            return this.restEndpointIdentifier((RestEndpointIdentifier)((RestEndpointIdentifier.Builder)RestEndpointIdentifier.builder().applyMutation(restEndpointIdentifier)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusException(StatusException var1);

        default public Builder statusException(Consumer<StatusException.Builder> statusException) {
            return this.statusException((StatusException)((StatusException.Builder)StatusException.builder().applyMutation(statusException)).build());
        }

        public Builder tryItState(String var1);

        public Builder tryItState(TryItState var1);
    }
}

