/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints;
import software.amazon.awssdk.services.apigatewayv2.model.RouteModelsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.RouteParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteResponse> {
    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelSelectionExpression").getter(RouteResponse.getter(RouteResponse::modelSelectionExpression)).setter(RouteResponse.setter(Builder::modelSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResponseModels").getter(RouteResponse.getter(RouteResponse::responseModels)).setter(RouteResponse.setter(Builder::responseModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ParameterConstraints>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResponseParameters").getter(RouteResponse.getter(RouteResponse::responseParameters)).setter(RouteResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_RESPONSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteResponseId").getter(RouteResponse.getter(RouteResponse::routeResponseId)).setter(RouteResponse.setter(Builder::routeResponseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseId").build()}).build();
    private static final SdkField<String> ROUTE_RESPONSE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteResponseKey").getter(RouteResponse.getter(RouteResponse::routeResponseKey)).setter(RouteResponse.setter(Builder::routeResponseKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SELECTION_EXPRESSION_FIELD, RESPONSE_MODELS_FIELD, RESPONSE_PARAMETERS_FIELD, ROUTE_RESPONSE_ID_FIELD, ROUTE_RESPONSE_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelSelectionExpression;
    private final Map<String, String> responseModels;
    private final Map<String, ParameterConstraints> responseParameters;
    private final String routeResponseId;
    private final String routeResponseKey;

    private RouteResponse(BuilderImpl builder) {
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.responseModels = builder.responseModels;
        this.responseParameters = builder.responseParameters;
        this.routeResponseId = builder.routeResponseId;
        this.routeResponseKey = builder.routeResponseKey;
    }

    public final String modelSelectionExpression() {
        return this.modelSelectionExpression;
    }

    public final boolean hasResponseModels() {
        return this.responseModels != null && !(this.responseModels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseModels() {
        return this.responseModels;
    }

    public final boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, ParameterConstraints> responseParameters() {
        return this.responseParameters;
    }

    public final String routeResponseId() {
        return this.routeResponseId;
    }

    public final String routeResponseKey() {
        return this.routeResponseKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseModels() ? this.responseModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseParameters() ? this.responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeResponseKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteResponse)) {
            return false;
        }
        RouteResponse other = (RouteResponse)obj;
        return Objects.equals(this.modelSelectionExpression(), other.modelSelectionExpression()) && this.hasResponseModels() == other.hasResponseModels() && Objects.equals(this.responseModels(), other.responseModels()) && this.hasResponseParameters() == other.hasResponseParameters() && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.routeResponseId(), other.routeResponseId()) && Objects.equals(this.routeResponseKey(), other.routeResponseKey());
    }

    public final String toString() {
        return ToString.builder((String)"RouteResponse").add("ModelSelectionExpression", (Object)this.modelSelectionExpression()).add("ResponseModels", this.hasResponseModels() ? this.responseModels() : null).add("ResponseParameters", this.hasResponseParameters() ? this.responseParameters() : null).add("RouteResponseId", (Object)this.routeResponseId()).add("RouteResponseKey", (Object)this.routeResponseKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.modelSelectionExpression()));
            }
            case "ResponseModels": {
                return Optional.ofNullable(clazz.cast(this.responseModels()));
            }
            case "ResponseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "RouteResponseId": {
                return Optional.ofNullable(clazz.cast(this.routeResponseId()));
            }
            case "RouteResponseKey": {
                return Optional.ofNullable(clazz.cast(this.routeResponseKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelSelectionExpression", MODEL_SELECTION_EXPRESSION_FIELD);
        map.put("responseModels", RESPONSE_MODELS_FIELD);
        map.put("responseParameters", RESPONSE_PARAMETERS_FIELD);
        map.put("routeResponseId", ROUTE_RESPONSE_ID_FIELD);
        map.put("routeResponseKey", ROUTE_RESPONSE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteResponse, T> g) {
        return obj -> g.apply((RouteResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelSelectionExpression;
        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ParameterConstraints> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private String routeResponseId;
        private String routeResponseKey;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteResponse model) {
            this.modelSelectionExpression(model.modelSelectionExpression);
            this.responseModels(model.responseModels);
            this.responseParameters(model.responseParameters);
            this.routeResponseId(model.routeResponseId);
            this.routeResponseKey(model.routeResponseKey);
        }

        public final String getModelSelectionExpression() {
            return this.modelSelectionExpression;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final Map<String, String> getResponseModels() {
            if (this.responseModels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseModels;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
            return this;
        }

        public final Map<String, ParameterConstraints.Builder> getResponseParameters() {
            Map<String, ParameterConstraints.Builder> result = RouteParametersCopier.copyToBuilder(this.responseParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResponseParameters(Map<String, ParameterConstraints.BuilderImpl> responseParameters) {
            this.responseParameters = RouteParametersCopier.copyFromBuilder(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, ParameterConstraints> responseParameters) {
            this.responseParameters = RouteParametersCopier.copy(responseParameters);
            return this;
        }

        public final String getRouteResponseId() {
            return this.routeResponseId;
        }

        public final void setRouteResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
        }

        @Override
        public final Builder routeResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
            return this;
        }

        public final String getRouteResponseKey() {
            return this.routeResponseKey;
        }

        public final void setRouteResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
        }

        @Override
        public final Builder routeResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
            return this;
        }

        public RouteResponse build() {
            return new RouteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteResponse> {
        public Builder modelSelectionExpression(String var1);

        public Builder responseModels(Map<String, String> var1);

        public Builder responseParameters(Map<String, ParameterConstraints> var1);

        public Builder routeResponseId(String var1);

        public Builder routeResponseKey(String var1);
    }
}

