/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportApiRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, ExportApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(ExportApiRequest.getter(ExportApiRequest::apiId)).setter(ExportApiRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> EXPORT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportVersion").getter(ExportApiRequest.getter(ExportApiRequest::exportVersion)).setter(ExportApiRequest.setter(Builder::exportVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("exportVersion").build()}).build();
    private static final SdkField<Boolean> INCLUDE_EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeExtensions").getter(ExportApiRequest.getter(ExportApiRequest::includeExtensions)).setter(ExportApiRequest.setter(Builder::includeExtensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeExtensions").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(ExportApiRequest.getter(ExportApiRequest::outputType)).setter(ExportApiRequest.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("outputType").build()}).build();
    private static final SdkField<String> SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Specification").getter(ExportApiRequest.getter(ExportApiRequest::specification)).setter(ExportApiRequest.setter(Builder::specification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("specification").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(ExportApiRequest.getter(ExportApiRequest::stageName)).setter(ExportApiRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("stageName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, EXPORT_VERSION_FIELD, INCLUDE_EXTENSIONS_FIELD, OUTPUT_TYPE_FIELD, SPECIFICATION_FIELD, STAGE_NAME_FIELD));
    private final String apiId;
    private final String exportVersion;
    private final Boolean includeExtensions;
    private final String outputType;
    private final String specification;
    private final String stageName;

    private ExportApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.exportVersion = builder.exportVersion;
        this.includeExtensions = builder.includeExtensions;
        this.outputType = builder.outputType;
        this.specification = builder.specification;
        this.stageName = builder.stageName;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String exportVersion() {
        return this.exportVersion;
    }

    public final Boolean includeExtensions() {
        return this.includeExtensions;
    }

    public final String outputType() {
        return this.outputType;
    }

    public final String specification() {
        return this.specification;
    }

    public final String stageName() {
        return this.stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeExtensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputType());
        hashCode = 31 * hashCode + Objects.hashCode(this.specification());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportApiRequest)) {
            return false;
        }
        ExportApiRequest other = (ExportApiRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.exportVersion(), other.exportVersion()) && Objects.equals(this.includeExtensions(), other.includeExtensions()) && Objects.equals(this.outputType(), other.outputType()) && Objects.equals(this.specification(), other.specification()) && Objects.equals(this.stageName(), other.stageName());
    }

    public final String toString() {
        return ToString.builder((String)"ExportApiRequest").add("ApiId", (Object)this.apiId()).add("ExportVersion", (Object)this.exportVersion()).add("IncludeExtensions", (Object)this.includeExtensions()).add("OutputType", (Object)this.outputType()).add("Specification", (Object)this.specification()).add("StageName", (Object)this.stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ExportVersion": {
                return Optional.ofNullable(clazz.cast(this.exportVersion()));
            }
            case "IncludeExtensions": {
                return Optional.ofNullable(clazz.cast(this.includeExtensions()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputType()));
            }
            case "Specification": {
                return Optional.ofNullable(clazz.cast(this.specification()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportApiRequest, T> g) {
        return obj -> g.apply((ExportApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String exportVersion;
        private Boolean includeExtensions;
        private String outputType;
        private String specification;
        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportApiRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.exportVersion(model.exportVersion);
            this.includeExtensions(model.includeExtensions);
            this.outputType(model.outputType);
            this.specification(model.specification);
            this.stageName(model.stageName);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getExportVersion() {
            return this.exportVersion;
        }

        public final void setExportVersion(String exportVersion) {
            this.exportVersion = exportVersion;
        }

        @Override
        public final Builder exportVersion(String exportVersion) {
            this.exportVersion = exportVersion;
            return this;
        }

        public final Boolean getIncludeExtensions() {
            return this.includeExtensions;
        }

        public final void setIncludeExtensions(Boolean includeExtensions) {
            this.includeExtensions = includeExtensions;
        }

        @Override
        public final Builder includeExtensions(Boolean includeExtensions) {
            this.includeExtensions = includeExtensions;
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        public final String getSpecification() {
            return this.specification;
        }

        public final void setSpecification(String specification) {
            this.specification = specification;
        }

        @Override
        public final Builder specification(String specification) {
            this.specification = specification;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportApiRequest build() {
            return new ExportApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportApiRequest> {
        public Builder apiId(String var1);

        public Builder exportVersion(String var1);

        public Builder includeExtensions(Boolean var1);

        public Builder outputType(String var1);

        public Builder specification(String var1);

        public Builder stageName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

