/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClientBuilder;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2ServiceClientConfiguration;
import software.amazon.awssdk.services.apigatewayv2.DefaultApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.DefaultApiGatewayV2BaseClientBuilder;
import software.amazon.awssdk.services.apigatewayv2.endpoints.ApiGatewayV2EndpointProvider;

@SdkInternalApi
final class DefaultApiGatewayV2AsyncClientBuilder
extends DefaultApiGatewayV2BaseClientBuilder<ApiGatewayV2AsyncClientBuilder, ApiGatewayV2AsyncClient>
implements ApiGatewayV2AsyncClientBuilder {
    DefaultApiGatewayV2AsyncClientBuilder() {
    }

    @Override
    public DefaultApiGatewayV2AsyncClientBuilder endpointProvider(ApiGatewayV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApiGatewayV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultApiGatewayV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        ApiGatewayV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultApiGatewayV2AsyncClient client = new DefaultApiGatewayV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ApiGatewayV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ApiGatewayV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

