/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecurityPolicy {
    TLS_1_0("TLS_1_0"),
    TLS_1_2("TLS_1_2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecurityPolicy> VALUE_MAP;
    private final String value;

    private SecurityPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityPolicy> knownValues() {
        EnumSet<SecurityPolicy> knownValues = EnumSet.allOf(SecurityPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecurityPolicy.class, SecurityPolicy::toString);
    }
}

