/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiMapping> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(ApiMapping.getter(ApiMapping::apiId)).setter(ApiMapping.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()}).build();
    private static final SdkField<String> API_MAPPING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiMappingId").getter(ApiMapping.getter(ApiMapping::apiMappingId)).setter(ApiMapping.setter(Builder::apiMappingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingId").build()}).build();
    private static final SdkField<String> API_MAPPING_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiMappingKey").getter(ApiMapping.getter(ApiMapping::apiMappingKey)).setter(ApiMapping.setter(Builder::apiMappingKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingKey").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(ApiMapping.getter(ApiMapping::stage)).setter(ApiMapping.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, API_MAPPING_ID_FIELD, API_MAPPING_KEY_FIELD, STAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiId;
    private final String apiMappingId;
    private final String apiMappingKey;
    private final String stage;

    private ApiMapping(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.apiMappingId = builder.apiMappingId;
        this.apiMappingKey = builder.apiMappingKey;
        this.stage = builder.stage;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String apiMappingId() {
        return this.apiMappingId;
    }

    public final String apiMappingKey() {
        return this.apiMappingKey;
    }

    public final String stage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiMappingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiMappingKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiMapping)) {
            return false;
        }
        ApiMapping other = (ApiMapping)obj;
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.apiMappingId(), other.apiMappingId()) && Objects.equals(this.apiMappingKey(), other.apiMappingKey()) && Objects.equals(this.stage(), other.stage());
    }

    public final String toString() {
        return ToString.builder((String)"ApiMapping").add("ApiId", (Object)this.apiId()).add("ApiMappingId", (Object)this.apiMappingId()).add("ApiMappingKey", (Object)this.apiMappingKey()).add("Stage", (Object)this.stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ApiMappingId": {
                return Optional.ofNullable(clazz.cast(this.apiMappingId()));
            }
            case "ApiMappingKey": {
                return Optional.ofNullable(clazz.cast(this.apiMappingKey()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiMapping, T> g) {
        return obj -> g.apply((ApiMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiId;
        private String apiMappingId;
        private String apiMappingKey;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiMapping model) {
            this.apiId(model.apiId);
            this.apiMappingId(model.apiMappingId);
            this.apiMappingKey(model.apiMappingKey);
            this.stage(model.stage);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiMappingId() {
            return this.apiMappingId;
        }

        @Override
        public final Builder apiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
            return this;
        }

        public final void setApiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
        }

        public final String getApiMappingKey() {
            return this.apiMappingKey;
        }

        @Override
        public final Builder apiMappingKey(String apiMappingKey) {
            this.apiMappingKey = apiMappingKey;
            return this;
        }

        public final void setApiMappingKey(String apiMappingKey) {
            this.apiMappingKey = apiMappingKey;
        }

        public final String getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public ApiMapping build() {
            return new ApiMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiMapping> {
        public Builder apiId(String var1);

        public Builder apiMappingId(String var1);

        public Builder apiMappingKey(String var1);

        public Builder stage(String var1);
    }
}

