/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigatewayv2.model.IntegrationParametersCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TemplateMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntegrationResponseRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreateIntegrationResponseRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(CreateIntegrationResponseRequest.getter(CreateIntegrationResponseRequest::apiId)).setter(CreateIntegrationResponseRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentHandlingStrategy").getter(CreateIntegrationResponseRequest.getter(CreateIntegrationResponseRequest::contentHandlingStrategyAsString)).setter(CreateIntegrationResponseRequest.setter(Builder::contentHandlingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build()}).build();
    private static final SdkField<String> INTEGRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationId").getter(CreateIntegrationResponseRequest.getter(CreateIntegrationResponseRequest::integrationId)).setter(CreateIntegrationResponseRequest.setter(Builder::integrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("integrationId").build()}).build();
    private static final SdkField<String> INTEGRATION_RESPONSE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationResponseKey").getter(CreateIntegrationResponseRequest.getter(CreateIntegrationResponseRequest::integrationResponseKey)).setter(CreateIntegrationResponseRequest.setter(Builder::integrationResponseKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseKey").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResponseParameters").getter(CreateIntegrationResponseRequest.getter(CreateIntegrationResponseRequest::responseParameters)).setter(CreateIntegrationResponseRequest.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResponseTemplates").getter(CreateIntegrationResponseRequest.getter(CreateIntegrationResponseRequest::responseTemplates)).setter(CreateIntegrationResponseRequest.setter(Builder::responseTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateSelectionExpression").getter(CreateIntegrationResponseRequest.getter(CreateIntegrationResponseRequest::templateSelectionExpression)).setter(CreateIntegrationResponseRequest.setter(Builder::templateSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, CONTENT_HANDLING_STRATEGY_FIELD, INTEGRATION_ID_FIELD, INTEGRATION_RESPONSE_KEY_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD));
    private final String apiId;
    private final String contentHandlingStrategy;
    private final String integrationId;
    private final String integrationResponseKey;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;
    private final String templateSelectionExpression;

    private CreateIntegrationResponseRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.integrationId = builder.integrationId;
        this.integrationResponseKey = builder.integrationResponseKey;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.templateSelectionExpression = builder.templateSelectionExpression;
    }

    public String apiId() {
        return this.apiId;
    }

    public ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(this.contentHandlingStrategy);
    }

    public String contentHandlingStrategyAsString() {
        return this.contentHandlingStrategy;
    }

    public String integrationId() {
        return this.integrationId;
    }

    public String integrationResponseKey() {
        return this.integrationResponseKey;
    }

    public boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public boolean hasResponseTemplates() {
        return this.responseTemplates != null && !(this.responseTemplates instanceof SdkAutoConstructMap);
    }

    public Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    public String templateSelectionExpression() {
        return this.templateSelectionExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationResponseKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateSelectionExpression());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationResponseRequest)) {
            return false;
        }
        CreateIntegrationResponseRequest other = (CreateIntegrationResponseRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString()) && Objects.equals(this.integrationId(), other.integrationId()) && Objects.equals(this.integrationResponseKey(), other.integrationResponseKey()) && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.responseTemplates(), other.responseTemplates()) && Objects.equals(this.templateSelectionExpression(), other.templateSelectionExpression());
    }

    public String toString() {
        return ToString.builder((String)"CreateIntegrationResponseRequest").add("ApiId", (Object)this.apiId()).add("ContentHandlingStrategy", (Object)this.contentHandlingStrategyAsString()).add("IntegrationId", (Object)this.integrationId()).add("IntegrationResponseKey", (Object)this.integrationResponseKey()).add("ResponseParameters", this.responseParameters()).add("ResponseTemplates", this.responseTemplates()).add("TemplateSelectionExpression", (Object)this.templateSelectionExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ContentHandlingStrategy": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingStrategyAsString()));
            }
            case "IntegrationId": {
                return Optional.ofNullable(clazz.cast(this.integrationId()));
            }
            case "IntegrationResponseKey": {
                return Optional.ofNullable(clazz.cast(this.integrationResponseKey()));
            }
            case "ResponseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "ResponseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
            case "TemplateSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.templateSelectionExpression()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationResponseRequest, T> g) {
        return obj -> g.apply((CreateIntegrationResponseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String contentHandlingStrategy;
        private String integrationId;
        private String integrationResponseKey;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String templateSelectionExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationResponseRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.contentHandlingStrategy(model.contentHandlingStrategy);
            this.integrationId(model.integrationId);
            this.integrationResponseKey(model.integrationResponseKey);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
            this.templateSelectionExpression(model.templateSelectionExpression);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getContentHandlingStrategy() {
            return this.contentHandlingStrategy;
        }

        @Override
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy == null ? null : contentHandlingStrategy.toString());
            return this;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        public final String getIntegrationId() {
            return this.integrationId;
        }

        @Override
        public final Builder integrationId(String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        public final void setIntegrationId(String integrationId) {
            this.integrationId = integrationId;
        }

        public final String getIntegrationResponseKey() {
            return this.integrationResponseKey;
        }

        @Override
        public final Builder integrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
            return this;
        }

        public final void setIntegrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
        }

        public final Map<String, String> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            return this.responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
        }

        public final String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        @Override
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationResponseRequest build() {
            return new CreateIntegrationResponseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntegrationResponseRequest> {
        public Builder apiId(String var1);

        public Builder contentHandlingStrategy(String var1);

        public Builder contentHandlingStrategy(ContentHandlingStrategy var1);

        public Builder integrationId(String var1);

        public Builder integrationResponseKey(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder templateSelectionExpression(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

