/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JWTConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JWTConfiguration> {
    private static final SdkField<List<String>> AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(JWTConfiguration.getter(JWTConfiguration::audience)).setter(JWTConfiguration.setter(Builder::audience)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audience").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JWTConfiguration.getter(JWTConfiguration::issuer)).setter(JWTConfiguration.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_FIELD, ISSUER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> audience;
    private final String issuer;

    private JWTConfiguration(BuilderImpl builder) {
        this.audience = builder.audience;
        this.issuer = builder.issuer;
    }

    public List<String> audience() {
        return this.audience;
    }

    public String issuer() {
        return this.issuer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audience());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JWTConfiguration)) {
            return false;
        }
        JWTConfiguration other = (JWTConfiguration)obj;
        return Objects.equals(this.audience(), other.audience()) && Objects.equals(this.issuer(), other.issuer());
    }

    public String toString() {
        return ToString.builder((String)"JWTConfiguration").add("Audience", this.audience()).add("Issuer", (Object)this.issuer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audience": {
                return Optional.ofNullable(clazz.cast(this.audience()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JWTConfiguration, T> g) {
        return obj -> g.apply((JWTConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> audience = DefaultSdkAutoConstructList.getInstance();
        private String issuer;

        private BuilderImpl() {
        }

        private BuilderImpl(JWTConfiguration model) {
            this.audience(model.audience);
            this.issuer(model.issuer);
        }

        public final Collection<String> getAudience() {
            return this.audience;
        }

        @Override
        public final Builder audience(Collection<String> audience) {
            this.audience = ___listOf__stringCopier.copy(audience);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audience(String ... audience) {
            this.audience(Arrays.asList(audience));
            return this;
        }

        public final void setAudience(Collection<String> audience) {
            this.audience = ___listOf__stringCopier.copy(audience);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public JWTConfiguration build() {
            return new JWTConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JWTConfiguration> {
        public Builder audience(Collection<String> var1);

        public Builder audience(String ... var1);

        public Builder issuer(String var1);
    }
}

