/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ApiKeysFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportApiKeysRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, ImportApiKeysRequest> {
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImportApiKeysRequest.getter(ImportApiKeysRequest::body)).setter(ImportApiKeysRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportApiKeysRequest.getter(ImportApiKeysRequest::formatAsString)).setter(ImportApiKeysRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final SdkField<Boolean> FAIL_ON_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ImportApiKeysRequest.getter(ImportApiKeysRequest::failOnWarnings)).setter(ImportApiKeysRequest.setter(Builder::failOnWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("failonwarnings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, FORMAT_FIELD, FAIL_ON_WARNINGS_FIELD));
    private final SdkBytes body;
    private final String format;
    private final Boolean failOnWarnings;

    private ImportApiKeysRequest(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.format = builder.format;
        this.failOnWarnings = builder.failOnWarnings;
    }

    public SdkBytes body() {
        return this.body;
    }

    public ApiKeysFormat format() {
        return ApiKeysFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public Boolean failOnWarnings() {
        return this.failOnWarnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failOnWarnings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportApiKeysRequest)) {
            return false;
        }
        ImportApiKeysRequest other = (ImportApiKeysRequest)((Object)obj);
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.failOnWarnings(), other.failOnWarnings());
    }

    public String toString() {
        return ToString.builder((String)"ImportApiKeysRequest").add("Body", (Object)this.body()).add("Format", (Object)this.formatAsString()).add("FailOnWarnings", (Object)this.failOnWarnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "failOnWarnings": {
                return Optional.ofNullable(clazz.cast(this.failOnWarnings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportApiKeysRequest, T> g) {
        return obj -> g.apply((ImportApiKeysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private SdkBytes body;
        private String format;
        private Boolean failOnWarnings;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportApiKeysRequest model) {
            super(model);
            this.body(model.body);
            this.format(model.format);
            this.failOnWarnings(model.failOnWarnings);
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy((SdkBytes)body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        public final String getFormatAsString() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ApiKeysFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public final void setFailOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportApiKeysRequest build() {
            return new ImportApiKeysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportApiKeysRequest> {
        public Builder body(SdkBytes var1);

        public Builder format(String var1);

        public Builder format(ApiKeysFormat var1);

        public Builder failOnWarnings(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

