/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.Op;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchOperation> {
    private static final SdkField<String> OP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchOperation.getter(PatchOperation::opAsString)).setter(PatchOperation.setter(Builder::op)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("op").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchOperation.getter(PatchOperation::path)).setter(PatchOperation.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchOperation.getter(PatchOperation::value)).setter(PatchOperation.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchOperation.getter(PatchOperation::from)).setter(PatchOperation.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OP_FIELD, PATH_FIELD, VALUE_FIELD, FROM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String op;
    private final String path;
    private final String value;
    private final String from;

    private PatchOperation(BuilderImpl builder) {
        this.op = builder.op;
        this.path = builder.path;
        this.value = builder.value;
        this.from = builder.from;
    }

    public Op op() {
        return Op.fromValue(this.op);
    }

    public String opAsString() {
        return this.op;
    }

    public String path() {
        return this.path;
    }

    public String value() {
        return this.value;
    }

    public String from() {
        return this.from;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchOperation)) {
            return false;
        }
        PatchOperation other = (PatchOperation)obj;
        return Objects.equals(this.opAsString(), other.opAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.from(), other.from());
    }

    public String toString() {
        return ToString.builder((String)"PatchOperation").add("Op", (Object)this.opAsString()).add("Path", (Object)this.path()).add("Value", (Object)this.value()).add("From", (Object)this.from()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "op": {
                return Optional.ofNullable(clazz.cast(this.opAsString()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "from": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchOperation, T> g) {
        return obj -> g.apply((PatchOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String op;
        private String path;
        private String value;
        private String from;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchOperation model) {
            this.op(model.op);
            this.path(model.path);
            this.value(model.value);
            this.from(model.from);
        }

        public final String getOpAsString() {
            return this.op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        @Override
        public final Builder op(Op op) {
            this.op(op.toString());
            return this;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        public PatchOperation build() {
            return new PatchOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchOperation> {
        public Builder op(String var1);

        public Builder op(Op var1);

        public Builder path(String var1);

        public Builder value(String var1);

        public Builder from(String var1);
    }
}

