/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThrottleSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThrottleSettings> {
    private static final SdkField<Integer> BURST_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ThrottleSettings.getter(ThrottleSettings::burstLimit)).setter(ThrottleSettings.setter(Builder::burstLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("burstLimit").build()}).build();
    private static final SdkField<Double> RATE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ThrottleSettings.getter(ThrottleSettings::rateLimit)).setter(ThrottleSettings.setter(Builder::rateLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BURST_LIMIT_FIELD, RATE_LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer burstLimit;
    private final Double rateLimit;

    private ThrottleSettings(BuilderImpl builder) {
        this.burstLimit = builder.burstLimit;
        this.rateLimit = builder.rateLimit;
    }

    public Integer burstLimit() {
        return this.burstLimit;
    }

    public Double rateLimit() {
        return this.rateLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.burstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThrottleSettings)) {
            return false;
        }
        ThrottleSettings other = (ThrottleSettings)obj;
        return Objects.equals(this.burstLimit(), other.burstLimit()) && Objects.equals(this.rateLimit(), other.rateLimit());
    }

    public String toString() {
        return ToString.builder((String)"ThrottleSettings").add("BurstLimit", (Object)this.burstLimit()).add("RateLimit", (Object)this.rateLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "burstLimit": {
                return Optional.ofNullable(clazz.cast(this.burstLimit()));
            }
            case "rateLimit": {
                return Optional.ofNullable(clazz.cast(this.rateLimit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThrottleSettings, T> g) {
        return obj -> g.apply((ThrottleSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer burstLimit;
        private Double rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottleSettings model) {
            this.burstLimit(model.burstLimit);
            this.rateLimit(model.rateLimit);
        }

        public final Integer getBurstLimit() {
            return this.burstLimit;
        }

        @Override
        public final Builder burstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
            return this;
        }

        public final void setBurstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
        }

        public final Double getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public final Builder rateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
        }

        public ThrottleSettings build() {
            return new ThrottleSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThrottleSettings> {
        public Builder burstLimit(Integer var1);

        public Builder rateLimit(Double var1);
    }
}

