/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.UsagePlan;

public class GetUsagePlansPublisher
implements SdkPublisher<GetUsagePlansResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetUsagePlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUsagePlansPublisher(ApiGatewayAsyncClient client, GetUsagePlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUsagePlansPublisher(ApiGatewayAsyncClient client, GetUsagePlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUsagePlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUsagePlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsagePlan> items() {
        return this.flatMapIterable(response -> response.items());
    }

    private class GetUsagePlansResponseFetcher
    implements AsyncPageFetcher<GetUsagePlansResponse> {
        private GetUsagePlansResponseFetcher() {
        }

        public boolean hasNextPage(GetUsagePlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetUsagePlansResponse> nextPage(GetUsagePlansResponse previousPage) {
            if (previousPage == null) {
                return GetUsagePlansPublisher.this.client.getUsagePlans(GetUsagePlansPublisher.this.firstRequest);
            }
            return GetUsagePlansPublisher.this.client.getUsagePlans((GetUsagePlansRequest)((Object)GetUsagePlansPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

