/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateResourceRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(CreateResourceRequest.getter(CreateResourceRequest::restApiId)).setter(CreateResourceRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentId").getter(CreateResourceRequest.getter(CreateResourceRequest::parentId)).setter(CreateResourceRequest.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("parent_id").build()}).build();
    private static final SdkField<String> PATH_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pathPart").getter(CreateResourceRequest.getter(CreateResourceRequest::pathPart)).setter(CreateResourceRequest.setter(Builder::pathPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathPart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, PARENT_ID_FIELD, PATH_PART_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResourceRequest.memberNameToFieldInitializer();
    private final String restApiId;
    private final String parentId;
    private final String pathPart;

    private CreateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.parentId = builder.parentId;
        this.pathPart = builder.pathPart;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String parentId() {
        return this.parentId;
    }

    public final String pathPart() {
        return this.pathPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceRequest)) {
            return false;
        }
        CreateResourceRequest other = (CreateResourceRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.pathPart(), other.pathPart());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceRequest").add("RestApiId", (Object)this.restApiId()).add("ParentId", (Object)this.parentId()).add("PathPart", (Object)this.pathPart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "parentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "pathPart": {
                return Optional.ofNullable(clazz.cast(this.pathPart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("parent_id", PARENT_ID_FIELD);
        map.put("pathPart", PATH_PART_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceRequest, T> g) {
        return obj -> g.apply((CreateResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String parentId;
        private String pathPart;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.parentId(model.parentId);
            this.pathPart(model.pathPart);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getParentId() {
            return this.parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getPathPart() {
            return this.pathPart;
        }

        public final void setPathPart(String pathPart) {
            this.pathPart = pathPart;
        }

        @Override
        public final Builder pathPart(String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceRequest build() {
            return new CreateResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceRequest> {
        public Builder restApiId(String var1);

        public Builder parentId(String var1);

        public Builder pathPart(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

