/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfKeyUsagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUsageResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetUsageResponse> {
    private static final SdkField<String> USAGE_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usagePlanId").getter(GetUsageResponse.getter(GetUsageResponse::usagePlanId)).setter(GetUsageResponse.setter(Builder::usagePlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usagePlanId").build()}).build();
    private static final SdkField<String> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startDate").getter(GetUsageResponse.getter(GetUsageResponse::startDate)).setter(GetUsageResponse.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final SdkField<String> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endDate").getter(GetUsageResponse.getter(GetUsageResponse::endDate)).setter(GetUsageResponse.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("position").getter(GetUsageResponse.getter(GetUsageResponse::position)).setter(GetUsageResponse.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<Map<String, List<List<Long>>>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("items").getter(GetUsageResponse.getter(GetUsageResponse::items)).setter(GetUsageResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_PLAN_ID_FIELD, START_DATE_FIELD, END_DATE_FIELD, POSITION_FIELD, ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUsageResponse.memberNameToFieldInitializer();
    private final String usagePlanId;
    private final String startDate;
    private final String endDate;
    private final String position;
    private final Map<String, List<List<Long>>> items;

    private GetUsageResponse(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.position = builder.position;
        this.items = builder.items;
    }

    public final String usagePlanId() {
        return this.usagePlanId;
    }

    public final String startDate() {
        return this.startDate;
    }

    public final String endDate() {
        return this.endDate;
    }

    public final String position() {
        return this.position;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<List<Long>>> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageResponse)) {
            return false;
        }
        GetUsageResponse other = (GetUsageResponse)((Object)obj);
        return Objects.equals(this.usagePlanId(), other.usagePlanId()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.position(), other.position()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"GetUsageResponse").add("UsagePlanId", (Object)this.usagePlanId()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Position", (Object)this.position()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usagePlanId": {
                return Optional.ofNullable(clazz.cast(this.usagePlanId()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usagePlanId", USAGE_PLAN_ID_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("endDate", END_DATE_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("values", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUsageResponse, T> g) {
        return obj -> g.apply((GetUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String usagePlanId;
        private String startDate;
        private String endDate;
        private String position;
        private Map<String, List<List<Long>>> items = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageResponse model) {
            super(model);
            this.usagePlanId(model.usagePlanId);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.position(model.position);
            this.items(model.items);
        }

        public final String getUsagePlanId() {
            return this.usagePlanId;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Map<String, ? extends Collection<? extends Collection<Long>>> getItems() {
            if (this.items instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.items;
        }

        public final void setItems(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
        }

        @Override
        public final Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
            return this;
        }

        @Override
        public GetUsageResponse build() {
            return new GetUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUsageResponse> {
        public Builder usagePlanId(String var1);

        public Builder startDate(String var1);

        public Builder endDate(String var1);

        public Builder position(String var1);

        public Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> var1);
    }
}

