/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiKeyResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, CreateApiKeyResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::id)).setter(CreateApiKeyResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::value)).setter(CreateApiKeyResponse.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::name)).setter(CreateApiKeyResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerId").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::customerId)).setter(CreateApiKeyResponse.setter(Builder::customerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::description)).setter(CreateApiKeyResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::enabled)).setter(CreateApiKeyResponse.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::createdDate)).setter(CreateApiKeyResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::lastUpdatedDate)).setter(CreateApiKeyResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final SdkField<List<String>> STAGE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stageKeys").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::stageKeys)).setter(CreateApiKeyResponse.setter(Builder::stageKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateApiKeyResponse.getter(CreateApiKeyResponse::tags)).setter(CreateApiKeyResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VALUE_FIELD, NAME_FIELD, CUSTOMER_ID_FIELD, DESCRIPTION_FIELD, ENABLED_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, STAGE_KEYS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApiKeyResponse.memberNameToFieldInitializer();
    private final String id;
    private final String value;
    private final String name;
    private final String customerId;
    private final String description;
    private final Boolean enabled;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;
    private final List<String> stageKeys;
    private final Map<String, String> tags;

    private CreateApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.value = builder.value;
        this.name = builder.name;
        this.customerId = builder.customerId;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.stageKeys = builder.stageKeys;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String value() {
        return this.value;
    }

    public final String name() {
        return this.name;
    }

    public final String customerId() {
        return this.customerId;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final boolean hasStageKeys() {
        return this.stageKeys != null && !(this.stageKeys instanceof SdkAutoConstructList);
    }

    public final List<String> stageKeys() {
        return this.stageKeys;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStageKeys() ? this.stageKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiKeyResponse)) {
            return false;
        }
        CreateApiKeyResponse other = (CreateApiKeyResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.customerId(), other.customerId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && this.hasStageKeys() == other.hasStageKeys() && Objects.equals(this.stageKeys(), other.stageKeys()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApiKeyResponse").add("Id", (Object)this.id()).add("Value", (Object)this.value()).add("Name", (Object)this.name()).add("CustomerId", (Object)this.customerId()).add("Description", (Object)this.description()).add("Enabled", (Object)this.enabled()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("StageKeys", this.hasStageKeys() ? this.stageKeys() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "customerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "stageKeys": {
                return Optional.ofNullable(clazz.cast(this.stageKeys()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("customerId", CUSTOMER_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("stageKeys", STAGE_KEYS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApiKeyResponse, T> g) {
        return obj -> g.apply((CreateApiKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String value;
        private String name;
        private String customerId;
        private String description;
        private Boolean enabled;
        private Instant createdDate;
        private Instant lastUpdatedDate;
        private List<String> stageKeys = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiKeyResponse model) {
            super(model);
            this.id(model.id);
            this.value(model.value);
            this.name(model.name);
            this.customerId(model.customerId);
            this.description(model.description);
            this.enabled(model.enabled);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.stageKeys(model.stageKeys);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final Collection<String> getStageKeys() {
            if (this.stageKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stageKeys;
        }

        public final void setStageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
        }

        @Override
        public final Builder stageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageKeys(String ... stageKeys) {
            this.stageKeys(Arrays.asList(stageKeys));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public CreateApiKeyResponse build() {
            return new CreateApiKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiKeyResponse> {
        public Builder id(String var1);

        public Builder value(String var1);

        public Builder name(String var1);

        public Builder customerId(String var1);

        public Builder description(String var1);

        public Builder enabled(Boolean var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder stageKeys(Collection<String> var1);

        public Builder stageKeys(String ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

