/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpAddressType {
    IPV4("ipv4"),
    DUALSTACK("dualstack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpAddressType> VALUE_MAP;
    private final String value;

    private IpAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpAddressType> knownValues() {
        EnumSet<IpAddressType> knownValues = EnumSet.allOf(IpAddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpAddressType.class, IpAddressType::toString);
    }
}

