/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.Resource;

public class GetResourcesPublisher
implements SdkPublisher<GetResourcesResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourcesPublisher(ApiGatewayAsyncClient client, GetResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourcesPublisher(ApiGatewayAsyncClient client, GetResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Resource> items() {
        Function<GetResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourcesResponseFetcher
    implements AsyncPageFetcher<GetResourcesResponse> {
        private GetResourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetResourcesResponse> nextPage(GetResourcesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcesPublisher.this.client.getResources(GetResourcesPublisher.this.firstRequest);
            }
            return GetResourcesPublisher.this.client.getResources((GetResourcesRequest)((Object)GetResourcesPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

