/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GET request to get the usage data of a usage plan in a specified time interval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetUsageRequest.Builder, GetUsageRequest> {
    private static final SdkField<String> USAGE_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usagePlanId").getter(getter(GetUsageRequest::usagePlanId)).setter(setter(Builder::usagePlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("usageplanId").build()).build();

    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("keyId")
            .getter(getter(GetUsageRequest::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("keyId").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startDate").getter(getter(GetUsageRequest::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endDate").getter(getter(GetUsageRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endDate").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetUsageRequest::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("position").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(GetUsageRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_PLAN_ID_FIELD,
            KEY_ID_FIELD, START_DATE_FIELD, END_DATE_FIELD, POSITION_FIELD, LIMIT_FIELD));

    private final String usagePlanId;

    private final String keyId;

    private final String startDate;

    private final String endDate;

    private final String position;

    private final Integer limit;

    private GetUsageRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.keyId = builder.keyId;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.position = builder.position;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The Id of the usage plan associated with the usage data.
     * </p>
     * 
     * @return The Id of the usage plan associated with the usage data.
     */
    public final String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * The Id of the API key associated with the resultant usage data.
     * </p>
     * 
     * @return The Id of the API key associated with the resultant usage data.
     */
    public final String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The starting date (e.g., 2016-01-01) of the usage data.
     * </p>
     * 
     * @return The starting date (e.g., 2016-01-01) of the usage data.
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The ending date (e.g., 2016-12-31) of the usage data.
     * </p>
     * 
     * @return The ending date (e.g., 2016-12-31) of the usage data.
     */
    public final String endDate() {
        return endDate;
    }

    /**
     * <p>
     * The current pagination position in the paged result set.
     * </p>
     * 
     * @return The current pagination position in the paged result set.
     */
    public final String position() {
        return position;
    }

    /**
     * <p>
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     * </p>
     * 
     * @return The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageRequest)) {
            return false;
        }
        GetUsageRequest other = (GetUsageRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(keyId(), other.keyId())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(position(), other.position()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageRequest").add("UsagePlanId", usagePlanId()).add("KeyId", keyId())
                .add("StartDate", startDate()).add("EndDate", endDate()).add("Position", position()).add("Limit", limit())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "keyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageRequest, T> g) {
        return obj -> g.apply((GetUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageRequest> {
        /**
         * <p>
         * The Id of the usage plan associated with the usage data.
         * </p>
         * 
         * @param usagePlanId
         *        The Id of the usage plan associated with the usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * The Id of the API key associated with the resultant usage data.
         * </p>
         * 
         * @param keyId
         *        The Id of the API key associated with the resultant usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The starting date (e.g., 2016-01-01) of the usage data.
         * </p>
         * 
         * @param startDate
         *        The starting date (e.g., 2016-01-01) of the usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The ending date (e.g., 2016-12-31) of the usage data.
         * </p>
         * 
         * @param endDate
         *        The ending date (e.g., 2016-12-31) of the usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * <p>
         * The current pagination position in the paged result set.
         * </p>
         * 
         * @param position
         *        The current pagination position in the paged result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * </p>
         * 
         * @param limit
         *        The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private String keyId;

        private String startDate;

        private String endDate;

        private String position;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
            keyId(model.keyId);
            startDate(model.startDate);
            endDate(model.endDate);
            position(model.position);
            limit(model.limit);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final String getKeyId() {
            return keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getStartDate() {
            return startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsageRequest build() {
            return new GetUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
