/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.UsagePlanKey;

public class GetUsagePlanKeysPublisher
implements SdkPublisher<GetUsagePlanKeysResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetUsagePlanKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUsagePlanKeysPublisher(ApiGatewayAsyncClient client, GetUsagePlanKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUsagePlanKeysPublisher(ApiGatewayAsyncClient client, GetUsagePlanKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUsagePlanKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUsagePlanKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsagePlanKey> items() {
        Function<GetUsagePlanKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetUsagePlanKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetUsagePlanKeysResponseFetcher
    implements AsyncPageFetcher<GetUsagePlanKeysResponse> {
        private GetUsagePlanKeysResponseFetcher() {
        }

        public boolean hasNextPage(GetUsagePlanKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetUsagePlanKeysResponse> nextPage(GetUsagePlanKeysResponse previousPage) {
            if (previousPage == null) {
                return GetUsagePlanKeysPublisher.this.client.getUsagePlanKeys(GetUsagePlanKeysPublisher.this.firstRequest);
            }
            return GetUsagePlanKeysPublisher.this.client.getUsagePlanKeys((GetUsagePlanKeysRequest)((Object)GetUsagePlanKeysPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

