/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetResourcesRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(GetResourcesRequest.getter(GetResourcesRequest::restApiId)).setter(GetResourcesRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("position").getter(GetResourcesRequest.getter(GetResourcesRequest::position)).setter(GetResourcesRequest.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("position").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(GetResourcesRequest.getter(GetResourcesRequest::limit)).setter(GetResourcesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<List<String>> EMBED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("embed").getter(GetResourcesRequest.getter(GetResourcesRequest::embed)).setter(GetResourcesRequest.setter(Builder::embed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("embed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, POSITION_FIELD, LIMIT_FIELD, EMBED_FIELD));
    private final String restApiId;
    private final String position;
    private final Integer limit;
    private final List<String> embed;

    private GetResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.position = builder.position;
        this.limit = builder.limit;
        this.embed = builder.embed;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String position() {
        return this.position;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final boolean hasEmbed() {
        return this.embed != null && !(this.embed instanceof SdkAutoConstructList);
    }

    public final List<String> embed() {
        return this.embed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmbed() ? this.embed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.limit(), other.limit()) && this.hasEmbed() == other.hasEmbed() && Objects.equals(this.embed(), other.embed());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcesRequest").add("RestApiId", (Object)this.restApiId()).add("Position", (Object)this.position()).add("Limit", (Object)this.limit()).add("Embed", this.hasEmbed() ? this.embed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "embed": {
                return Optional.ofNullable(clazz.cast(this.embed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesRequest, T> g) {
        return obj -> g.apply((GetResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String position;
        private Integer limit;
        private List<String> embed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.position(model.position);
            this.limit(model.limit);
            this.embed(model.embed);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        @Transient
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        @Transient
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Collection<String> getEmbed() {
            if (this.embed instanceof SdkAutoConstructList) {
                return null;
            }
            return this.embed;
        }

        public final void setEmbed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
        }

        @Override
        @Transient
        public final Builder embed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder embed(String ... embed) {
            this.embed(Arrays.asList(embed));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesRequest build() {
            return new GetResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesRequest> {
        public Builder restApiId(String var1);

        public Builder position(String var1);

        public Builder limit(Integer var1);

        public Builder embed(Collection<String> var1);

        public Builder embed(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

